/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.sample.item.reader;

import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.item.file.mapping.FieldSet;
import org.springframework.batch.item.file.mapping.FieldSetMapper;
import org.springframework.batch.item.support.DelegatingItemReader;
import org.springframework.batch.sample.domain.Address;
import org.springframework.batch.sample.domain.BillingInfo;
import org.springframework.batch.sample.domain.Customer;
import org.springframework.batch.sample.domain.Order;
import org.springframework.batch.sample.domain.ShippingInfo;

public class OrderItemReader
extends DelegatingItemReader {
    private static Log log = LogFactory.getLog((Class)OrderItemReader.class);
    private Order order;
    private boolean recordFinished;
    private FieldSetMapper headerMapper;
    private FieldSetMapper customerMapper;
    private FieldSetMapper addressMapper;
    private FieldSetMapper billingMapper;
    private FieldSetMapper itemMapper;
    private FieldSetMapper shippingMapper;

    public Object read() throws Exception {
        this.recordFinished = false;
        while (!this.recordFinished) {
            this.process((FieldSet)super.read());
        }
        log.info((Object)("Mapped: " + this.order));
        Order result = this.order;
        this.order = null;
        return result;
    }

    private void process(FieldSet fieldSet) {
        if (fieldSet == null) {
            log.debug((Object)"FINISHED");
            this.recordFinished = true;
            this.order = null;
            return;
        }
        String lineId = fieldSet.readString(0);
        if ("HEA".equals(lineId)) {
            log.debug((Object)"STARTING NEW RECORD");
            this.order = (Order)this.headerMapper.mapLine(fieldSet);
            return;
        }
        if ("FOT".equals(lineId)) {
            log.debug((Object)"END OF RECORD");
            this.order.setTotalPrice(fieldSet.readBigDecimal("TOTAL_PRICE"));
            this.order.setTotalLines(fieldSet.readInt("TOTAL_LINE_ITEMS"));
            this.order.setTotalItems(fieldSet.readInt("TOTAL_ITEMS"));
            this.recordFinished = true;
            return;
        }
        if ("BCU".equals(lineId)) {
            log.debug((Object)"MAPPING CUSTOMER");
            if (this.order.getCustomer() == null) {
                this.order.setCustomer((Customer)this.customerMapper.mapLine(fieldSet));
                this.order.getCustomer().setBusinessCustomer(true);
            }
            return;
        }
        if ("NCU".equals(lineId)) {
            log.debug((Object)"MAPPING CUSTOMER");
            if (this.order.getCustomer() == null) {
                this.order.setCustomer((Customer)this.customerMapper.mapLine(fieldSet));
                this.order.getCustomer().setBusinessCustomer(false);
            }
            return;
        }
        if ("BAD".equals(lineId)) {
            log.debug((Object)"MAPPING BILLING ADDRESS");
            this.order.setBillingAddress((Address)this.addressMapper.mapLine(fieldSet));
            return;
        }
        if ("SAD".equals(lineId)) {
            log.debug((Object)"MAPPING SHIPPING ADDRESS");
            this.order.setShippingAddress((Address)this.addressMapper.mapLine(fieldSet));
            return;
        }
        if ("BIN".equals(lineId)) {
            log.debug((Object)"MAPPING BILLING INFO");
            this.order.setBilling((BillingInfo)this.billingMapper.mapLine(fieldSet));
            return;
        }
        if ("SIN".equals(lineId)) {
            log.debug((Object)"MAPPING SHIPPING INFO");
            this.order.setShipping((ShippingInfo)this.shippingMapper.mapLine(fieldSet));
            return;
        }
        if ("LIT".equals(lineId)) {
            log.debug((Object)"MAPPING LINE ITEM");
            if (this.order.getLineItems() == null) {
                this.order.setLineItems(new ArrayList());
            }
            this.order.getLineItems().add(this.itemMapper.mapLine(fieldSet));
            return;
        }
        log.debug((Object)("Could not map LINE_ID=" + lineId));
    }

    public void setAddressMapper(FieldSetMapper addressMapper) {
        this.addressMapper = addressMapper;
    }

    public void setBillingMapper(FieldSetMapper billingMapper) {
        this.billingMapper = billingMapper;
    }

    public void setCustomerMapper(FieldSetMapper customerMapper) {
        this.customerMapper = customerMapper;
    }

    public void setHeaderMapper(FieldSetMapper headerMapper) {
        this.headerMapper = headerMapper;
    }

    public void setItemMapper(FieldSetMapper itemMapper) {
        this.itemMapper = itemMapper;
    }

    public void setShippingMapper(FieldSetMapper shippingMapper) {
        this.shippingMapper = shippingMapper;
    }
}

