/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.sample.item.writer;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.item.support.AbstractItemWriter;
import org.springframework.batch.sample.dao.TradeDao;
import org.springframework.batch.sample.domain.Trade;

public class TradeWriter
extends AbstractItemWriter {
    private static Log log = LogFactory.getLog((Class)TradeWriter.class);
    private TradeDao dao;
    private int failure = -1;
    private int index = 0;

    public void setFailure(int failure) {
        this.failure = failure;
    }

    public void write(Object data) {
        if (!(data instanceof Trade)) {
            log.warn((Object)"TradeProcessor can process only Trade objects, skipping record");
            return;
        }
        Trade trade = (Trade)data;
        log.debug(data);
        this.dao.writeTrade(trade);
        if (this.index++ == this.failure) {
            throw new RuntimeException("Something unexpected happened!");
        }
    }

    public void setDao(TradeDao dao) {
        this.dao = dao;
    }
}

