/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.sample.quartz;

import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.springframework.batch.core.JobExecutionException;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.JobParametersBuilder;
import org.springframework.batch.core.configuration.JobLocator;
import org.springframework.batch.core.launch.JobLauncher;
import org.springframework.scheduling.quartz.QuartzJobBean;

public class JobLauncherDetails
extends QuartzJobBean {
    static final String JOB_NAME = "jobName";
    private static Log log = LogFactory.getLog((Class)JobLauncherDetails.class);
    private JobLocator jobLocator;
    private JobLauncher jobLauncher;

    public void setJobLocator(JobLocator jobLocator) {
        this.jobLocator = jobLocator;
    }

    public void setJobLauncher(JobLauncher jobLauncher) {
        this.jobLauncher = jobLauncher;
    }

    protected void executeInternal(JobExecutionContext context) {
        JobDataMap jobDataMap = context.getMergedJobDataMap();
        String jobName = (String)jobDataMap.get(JOB_NAME);
        log.info((Object)("Quartz trigger firing with Spring Batch jobName=" + jobName));
        JobParameters jobParameters = this.getJobParametersFromJobMap((Map)jobDataMap);
        try {
            this.jobLauncher.run(this.jobLocator.getJob(jobName), jobParameters);
        }
        catch (JobExecutionException e) {
            log.error((Object)"Could not execute job.", (Throwable)e);
        }
    }

    private JobParameters getJobParametersFromJobMap(Map jobDataMap) {
        JobParametersBuilder builder = new JobParametersBuilder();
        Iterator iterator = jobDataMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            if (value instanceof String && !key.equals(JOB_NAME)) {
                builder.addString(key, (String)value);
                continue;
            }
            if (value instanceof Float || value instanceof Double) {
                builder.addDouble(key, (Double)value);
                continue;
            }
            if (value instanceof Integer || value instanceof Long) {
                builder.addLong(key, (Long)value);
                continue;
            }
            if (value instanceof Date) {
                builder.addDate(key, (Date)value);
                continue;
            }
            log.debug((Object)"JobDataMap contains values which are not job parameters (ignoring).");
        }
        return builder.toJobParameters();
    }
}

