/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.sample.tasklet;

import java.io.File;
import org.springframework.batch.core.UnexpectedJobExecutionException;
import org.springframework.batch.core.step.tasklet.Tasklet;
import org.springframework.batch.repeat.ExitStatus;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;

public class FileDeletingTasklet
implements Tasklet,
InitializingBean {
    private Resource directory;

    public ExitStatus execute() throws Exception {
        File dir = this.directory.getFile();
        Assert.state((boolean)dir.isDirectory());
        File[] files = dir.listFiles();
        for (int i = 0; i < files.length; ++i) {
            boolean deleted = files[i].delete();
            if (deleted) continue;
            throw new UnexpectedJobExecutionException("Could not delete file " + files[i].getPath());
        }
        return ExitStatus.FINISHED;
    }

    public void setDirectoryResource(Resource directory) {
        this.directory = directory;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.directory, (String)"directory must be set");
    }
}

