/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.sample.tasklet;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.listener.StepExecutionListenerSupport;
import org.springframework.batch.core.step.tasklet.Tasklet;
import org.springframework.batch.repeat.ExitStatus;

public class InfiniteLoopTasklet
extends StepExecutionListenerSupport
implements Tasklet {
    private StepExecution stepExecution;
    private int count = 0;
    private static final Log logger = LogFactory.getLog((Class)InfiniteLoopTasklet.class);

    public ExitStatus execute() throws Exception {
        while (!this.stepExecution.isTerminateOnly()) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException("Job interrupted.");
            }
            this.stepExecution.setItemCount(++this.count);
            logger.info((Object)("Executing infinite loop, at count=" + this.count));
        }
        this.stepExecution.setStatus(BatchStatus.STOPPING);
        return ExitStatus.FAILED;
    }

    public void beforeStep(StepExecution stepExecution) {
        this.stepExecution = stepExecution;
    }
}

