/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.test;

import java.lang.reflect.Method;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.scope.context.StepSynchronizationManager;
import org.springframework.batch.item.adapter.HippyMethodInvoker;
import org.springframework.batch.test.MetaDataInstanceFactory;
import org.springframework.test.context.TestContext;
import org.springframework.test.context.TestExecutionListener;
import org.springframework.util.ReflectionUtils;

public class StepScopeTestExecutionListener
implements TestExecutionListener {
    private static final String STEP_EXECUTION = String.valueOf(StepScopeTestExecutionListener.class.getName()) + ".STEP_EXECUTION";

    public void prepareTestInstance(TestContext testContext) throws Exception {
        StepExecution stepExecution = this.getStepExecution(testContext);
        if (stepExecution != null) {
            testContext.setAttribute(STEP_EXECUTION, (Object)stepExecution);
        }
    }

    public void beforeTestMethod(TestContext testContext) throws Exception {
        if (testContext.hasAttribute(STEP_EXECUTION)) {
            StepExecution stepExecution = (StepExecution)testContext.getAttribute(STEP_EXECUTION);
            StepSynchronizationManager.register((StepExecution)stepExecution);
        }
    }

    public void afterTestMethod(TestContext testContext) throws Exception {
        if (testContext.hasAttribute(STEP_EXECUTION)) {
            StepSynchronizationManager.close();
        }
    }

    public void afterTestClass(TestContext testContext) throws Exception {
    }

    public void beforeTestClass(TestContext testContext) throws Exception {
    }

    protected StepExecution getStepExecution(TestContext testContext) {
        Object target = testContext.getTestInstance();
        ExtractorMethodCallback method = new ExtractorMethodCallback(StepExecution.class, "getStepExecution");
        ReflectionUtils.doWithMethods(target.getClass(), (ReflectionUtils.MethodCallback)method);
        if (method.getName() != null) {
            HippyMethodInvoker invoker = new HippyMethodInvoker();
            invoker.setTargetObject(target);
            invoker.setTargetMethod(method.getName());
            try {
                invoker.prepare();
                return (StepExecution)invoker.invoke();
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Could not create step execution from method: " + method.getName(), e);
            }
        }
        return MetaDataInstanceFactory.createStepExecution();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class ExtractorMethodCallback
    implements ReflectionUtils.MethodCallback {
        private String preferredName;
        private final Class<?> preferredType;
        private Method result;

        public ExtractorMethodCallback(Class<?> preferredType, String preferredName) {
            this.preferredType = preferredType;
            this.preferredName = preferredName;
        }

        public String getName() {
            return this.result == null ? null : this.result.getName();
        }

        public void doWith(Method method) throws IllegalArgumentException, IllegalAccessException {
            Class<?> type = method.getReturnType();
            if (this.preferredType.isAssignableFrom(type) && (this.result == null || method.getName().equals(this.preferredName))) {
                this.result = method;
            }
        }
    }
}

