/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.aws.cache.redis;

import org.springframework.beans.factory.DisposableBean;
import org.springframework.cache.Cache;
import org.springframework.cloud.aws.cache.AbstractCacheFactory;
import org.springframework.data.redis.cache.PublicRedisCache;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.jedis.JedisConnectionFactory;
import org.springframework.data.redis.connection.jredis.JredisConnectionFactory;
import org.springframework.data.redis.connection.lettuce.LettuceConnectionFactory;
import org.springframework.data.redis.connection.srp.SrpConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.util.ClassUtils;

public class RedisCacheFactory
extends AbstractCacheFactory<RedisConnectionFactory> {
    private static final boolean JEDIS_AVAILABLE = ClassUtils.isPresent((String)"redis.clients.jedis.Jedis", (ClassLoader)ClassUtils.getDefaultClassLoader());
    private static final boolean JREDIS_AVAILABLE = ClassUtils.isPresent((String)"org.jredis.JRedis", (ClassLoader)ClassUtils.getDefaultClassLoader());
    private static final boolean SRP_AVAILABLE = ClassUtils.isPresent((String)"redis.client.RedisClient", (ClassLoader)ClassUtils.getDefaultClassLoader());
    private static final boolean LETTUCE_AVAILABLE = ClassUtils.isPresent((String)"com.lambdaworks.redis.RedisClient", (ClassLoader)ClassUtils.getDefaultClassLoader());

    @Override
    public boolean isSupportingCacheArchitecture(String architecture) {
        return "redis".equalsIgnoreCase(architecture);
    }

    @Override
    public Cache createCache(String cacheName, String host, int port) throws Exception {
        return new PublicRedisCache(cacheName, null, this.getRedisTemplate((RedisConnectionFactory)this.getConnectionFactory(host, port)), this.getExpiryTime(cacheName));
    }

    @Override
    protected void destroyConnectionClient(RedisConnectionFactory connectionClient) throws Exception {
        if (connectionClient instanceof DisposableBean) {
            ((DisposableBean)connectionClient).destroy();
        }
    }

    @Override
    protected RedisConnectionFactory createConnectionClient(String hostName, int port) {
        if (JEDIS_AVAILABLE) {
            JedisConnectionFactory connectionFactory = new JedisConnectionFactory();
            connectionFactory.setHostName(hostName);
            connectionFactory.setPort(port);
            return connectionFactory;
        }
        if (JREDIS_AVAILABLE) {
            JredisConnectionFactory connectionFactory = new JredisConnectionFactory();
            connectionFactory.setHostName(hostName);
            connectionFactory.setPort(port);
            return connectionFactory;
        }
        if (SRP_AVAILABLE) {
            SrpConnectionFactory connectionFactory = new SrpConnectionFactory();
            connectionFactory.setHostName(hostName);
            connectionFactory.setPort(port);
            return connectionFactory;
        }
        if (LETTUCE_AVAILABLE) {
            LettuceConnectionFactory lettuceConnectionFactory = new LettuceConnectionFactory();
            lettuceConnectionFactory.setHostName(hostName);
            lettuceConnectionFactory.setPort(port);
            return lettuceConnectionFactory;
        }
        throw new IllegalArgumentException("No Jedis, Jredis, SRP or lettuce redis client on classpath. Please add one of the implementation to your classpath");
    }

    protected RedisTemplate<?, ?> getRedisTemplate(RedisConnectionFactory redisConnectionFactory) {
        RedisTemplate redisTemplate = new RedisTemplate();
        redisTemplate.setConnectionFactory(redisConnectionFactory);
        redisTemplate.afterPropertiesSet();
        return redisTemplate;
    }
}

