/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.aws.core.config;

import com.amazonaws.regions.Regions;
import java.beans.Introspector;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.MethodInvokingFactoryBean;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.cloud.aws.core.credentials.CredentialsProviderFactoryBean;
import org.springframework.cloud.aws.core.region.StaticRegionProvider;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public final class AmazonWebserviceClientConfigurationUtils {
    private static final String SERVICE_IMPLEMENTATION_SUFFIX = "Client";
    public static final String REGION_PROVIDER_BEAN_NAME = "org.springframework.cloud.aws.core.region.RegionProvider.BEAN_NAME";
    public static final String CREDENTIALS_PROVIDER_BEAN_NAME = "org.springframework.cloud.aws.core.credentials.CredentialsProviderFactoryBean.BEAN_NAME";

    private AmazonWebserviceClientConfigurationUtils() {
    }

    public static BeanDefinitionHolder registerAmazonWebserviceClient(Object source, BeanDefinitionRegistry registry, String serviceNameClassName, String customRegionProvider, String customRegion) {
        String beanName = AmazonWebserviceClientConfigurationUtils.getBeanName(serviceNameClassName);
        if (registry.containsBeanDefinition(beanName)) {
            return new BeanDefinitionHolder(registry.getBeanDefinition(beanName), beanName);
        }
        AbstractBeanDefinition definition = AmazonWebserviceClientConfigurationUtils.getAmazonWebserviceClientBeanDefinition(source, serviceNameClassName, customRegionProvider, customRegion, registry);
        BeanDefinitionHolder holder = new BeanDefinitionHolder((BeanDefinition)definition, beanName);
        BeanDefinitionReaderUtils.registerBeanDefinition((BeanDefinitionHolder)holder, (BeanDefinitionRegistry)registry);
        return holder;
    }

    public static AbstractBeanDefinition getAmazonWebserviceClientBeanDefinition(Object source, String serviceNameClassName, String customRegionProvider, String customRegion, BeanDefinitionRegistry beanDefinitionRegistry) {
        if (StringUtils.hasText((String)customRegionProvider) && StringUtils.hasText((String)customRegion)) {
            throw new IllegalArgumentException("Only region or regionProvider can be configured, but not both");
        }
        AmazonWebserviceClientConfigurationUtils.registerCredentialsProviderIfNeeded(beanDefinitionRegistry);
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition((String)serviceNameClassName);
        builder.addConstructorArgReference(CREDENTIALS_PROVIDER_BEAN_NAME);
        builder.setDestroyMethodName("shutdown");
        builder.getRawBeanDefinition().setSource(source);
        if (StringUtils.hasText((String)customRegionProvider)) {
            BeanDefinitionBuilder beanDefinitionBuilder = BeanDefinitionBuilder.genericBeanDefinition(MethodInvokingFactoryBean.class);
            beanDefinitionBuilder.addPropertyValue("targetObject", (Object)new RuntimeBeanReference(customRegionProvider));
            beanDefinitionBuilder.addPropertyValue("targetMethod", (Object)"getRegion");
            builder.addPropertyValue("region", (Object)beanDefinitionBuilder.getBeanDefinition());
        } else if (StringUtils.hasText((String)customRegion)) {
            BeanDefinitionBuilder beanDefinitionBuilder = BeanDefinitionBuilder.genericBeanDefinition((String)"com.amazonaws.regions.RegionUtils");
            beanDefinitionBuilder.setFactoryMethod("getRegion");
            beanDefinitionBuilder.addConstructorArgValue((Object)customRegion);
            builder.addPropertyValue("region", (Object)beanDefinitionBuilder.getBeanDefinition());
        } else {
            AmazonWebserviceClientConfigurationUtils.registerRegionProviderBeanIfNeeded(beanDefinitionRegistry);
            BeanDefinitionBuilder beanDefinitionBuilder = BeanDefinitionBuilder.genericBeanDefinition(MethodInvokingFactoryBean.class);
            beanDefinitionBuilder.addPropertyValue("targetObject", (Object)new RuntimeBeanReference(REGION_PROVIDER_BEAN_NAME));
            beanDefinitionBuilder.addPropertyValue("targetMethod", (Object)"getRegion");
            builder.addPropertyValue("region", (Object)beanDefinitionBuilder.getBeanDefinition());
        }
        return builder.getBeanDefinition();
    }

    public static String getBeanName(String serviceClassName) {
        String clientClassName = ClassUtils.getShortName((String)serviceClassName);
        String shortenedClassName = StringUtils.delete((String)clientClassName, (String)SERVICE_IMPLEMENTATION_SUFFIX);
        return Introspector.decapitalize(shortenedClassName);
    }

    public static String getRegionProviderBeanName(BeanDefinitionRegistry beanDefinitionRegistry) {
        AmazonWebserviceClientConfigurationUtils.registerRegionProviderBeanIfNeeded(beanDefinitionRegistry);
        return REGION_PROVIDER_BEAN_NAME;
    }

    public static void replaceDefaultRegionProvider(BeanDefinitionRegistry registry, String customGlobalRegionProvider) {
        if (registry.containsBeanDefinition(REGION_PROVIDER_BEAN_NAME)) {
            registry.removeBeanDefinition(REGION_PROVIDER_BEAN_NAME);
        }
        registry.registerAlias(customGlobalRegionProvider, REGION_PROVIDER_BEAN_NAME);
    }

    private static void registerRegionProviderBeanIfNeeded(BeanDefinitionRegistry registry) {
        if (!registry.containsBeanDefinition(REGION_PROVIDER_BEAN_NAME)) {
            BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(StaticRegionProvider.class);
            builder.addConstructorArgValue((Object)Regions.DEFAULT_REGION.getName());
            builder.setRole(2);
            registry.registerBeanDefinition(REGION_PROVIDER_BEAN_NAME, (BeanDefinition)builder.getBeanDefinition());
        }
    }

    private static void registerCredentialsProviderIfNeeded(BeanDefinitionRegistry registry) {
        if (!registry.containsBeanDefinition(CREDENTIALS_PROVIDER_BEAN_NAME)) {
            BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(CredentialsProviderFactoryBean.class);
            builder.setRole(2);
            registry.registerBeanDefinition(CREDENTIALS_PROVIDER_BEAN_NAME, (BeanDefinition)builder.getBeanDefinition());
        }
    }

    public static void replaceDefaultCredentialsProvider(BeanDefinitionRegistry registry, String customGlobalCredentialsProvider) {
        if (registry.containsBeanDefinition(CREDENTIALS_PROVIDER_BEAN_NAME)) {
            registry.removeBeanDefinition(CREDENTIALS_PROVIDER_BEAN_NAME);
        }
        registry.registerAlias(customGlobalCredentialsProvider, CREDENTIALS_PROVIDER_BEAN_NAME);
    }
}

