/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.aws.core.config.support;

import org.springframework.beans.factory.config.BeanExpressionContext;
import org.springframework.beans.factory.config.BeanExpressionResolver;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;

public final class ContextAnnotationConfigUtil {
    private ContextAnnotationConfigUtil() {
    }

    public static String resolveStringValue(ConfigurableBeanFactory configurableBeanFactory, String defaultValue) {
        if (configurableBeanFactory == null) {
            return defaultValue;
        }
        String placeholdersResolved = configurableBeanFactory.resolveEmbeddedValue(defaultValue);
        BeanExpressionResolver exprResolver = configurableBeanFactory.getBeanExpressionResolver();
        if (exprResolver == null) {
            return defaultValue;
        }
        Object result = exprResolver.evaluate(placeholdersResolved, new BeanExpressionContext(configurableBeanFactory, null));
        return result != null ? result.toString() : defaultValue;
    }
}

