/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.aws.core.env.stack.config;

import com.amazonaws.services.cloudformation.AmazonCloudFormation;
import com.amazonaws.services.cloudformation.model.DescribeStackResourcesRequest;
import com.amazonaws.services.cloudformation.model.DescribeStackResourcesResult;
import com.amazonaws.services.cloudformation.model.StackResource;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.cloud.aws.core.env.ec2.AmazonEc2InstanceIdProvider;
import org.springframework.cloud.aws.core.env.ec2.InstanceIdProvider;
import org.springframework.cloud.aws.core.env.stack.config.StackNameProvider;
import org.springframework.util.Assert;

class AutoDetectingStackNameProvider
implements StackNameProvider,
InitializingBean {
    private final AmazonCloudFormation amazonCloudFormationClient;
    private final InstanceIdProvider instanceIdProvider;
    private String stackName;

    AutoDetectingStackNameProvider(AmazonCloudFormation amazonCloudFormationClient, InstanceIdProvider instanceIdProvider) {
        this.amazonCloudFormationClient = amazonCloudFormationClient;
        this.instanceIdProvider = instanceIdProvider;
        this.afterPropertiesSet();
    }

    AutoDetectingStackNameProvider(AmazonCloudFormation amazonCloudFormationClient) {
        this(amazonCloudFormationClient, new AmazonEc2InstanceIdProvider());
    }

    public void afterPropertiesSet() {
        this.stackName = AutoDetectingStackNameProvider.autoDetectStackName(this.amazonCloudFormationClient, this.instanceIdProvider.getCurrentInstanceId());
    }

    @Override
    public String getStackName() {
        return this.stackName;
    }

    private static String autoDetectStackName(AmazonCloudFormation amazonCloudFormationClient, String instanceId) {
        Assert.notNull((Object)instanceId, (String)"No valid instance id defined");
        DescribeStackResourcesResult describeStackResourcesResult = amazonCloudFormationClient.describeStackResources(new DescribeStackResourcesRequest().withPhysicalResourceId(instanceId));
        if (describeStackResourcesResult == null || describeStackResourcesResult.getStackResources() == null || describeStackResourcesResult.getStackResources().isEmpty()) {
            throw new IllegalStateException("No stack resources found in stack for EC2 instance '" + instanceId + "'");
        }
        return ((StackResource)describeStackResourcesResult.getStackResources().get(0)).getStackName();
    }
}

