/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.aws.core.config;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.regions.Region;
import com.amazonaws.regions.RegionUtils;
import java.lang.reflect.Constructor;
import java.util.concurrent.ExecutorService;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.config.AbstractFactoryBean;
import org.springframework.cloud.aws.core.region.RegionProvider;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class AmazonWebserviceClientFactoryBean<T extends AmazonWebServiceClient>
extends AbstractFactoryBean<T> {
    private final Class<? extends AmazonWebServiceClient> clientClass;
    private final AWSCredentialsProvider credentialsProvider;
    private RegionProvider regionProvider;
    private Region customRegion;
    private ExecutorService executor;

    public AmazonWebserviceClientFactoryBean(Class<T> clientClass, AWSCredentialsProvider credentialsProvider) {
        this.clientClass = clientClass;
        this.credentialsProvider = credentialsProvider;
    }

    public Class<?> getObjectType() {
        return this.clientClass;
    }

    protected T createInstance() throws Exception {
        AmazonWebServiceClient webServiceClient;
        if (this.executor != null) {
            Constructor constructor = ClassUtils.getConstructorIfAvailable(this.clientClass, (Class[])new Class[]{AWSCredentialsProvider.class, ExecutorService.class});
            Assert.notNull((Object)constructor);
            webServiceClient = (AmazonWebServiceClient)BeanUtils.instantiateClass((Constructor)constructor, (Object[])new Object[]{this.credentialsProvider, this.executor});
        } else {
            Constructor constructor = ClassUtils.getConstructorIfAvailable(this.clientClass, (Class[])new Class[]{AWSCredentialsProvider.class});
            Assert.notNull((Object)constructor);
            webServiceClient = (AmazonWebServiceClient)BeanUtils.instantiateClass((Constructor)constructor, (Object[])new Object[]{this.credentialsProvider});
        }
        if (this.customRegion != null) {
            webServiceClient.setRegion(this.customRegion);
        } else if (this.regionProvider != null) {
            webServiceClient.setRegion(this.regionProvider.getRegion());
        }
        return (T)webServiceClient;
    }

    public void setRegionProvider(RegionProvider regionProvider) {
        this.regionProvider = regionProvider;
    }

    public void setCustomRegion(String customRegionName) {
        this.customRegion = RegionUtils.getRegion((String)customRegionName);
    }

    public void setExecutor(ExecutorService executor) {
        this.executor = executor;
    }

    protected void destroyInstance(T instance) throws Exception {
        instance.shutdown();
    }
}

