/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.aws.core.env.stack.config;

import com.amazonaws.services.cloudformation.AmazonCloudFormation;
import com.amazonaws.services.cloudformation.model.ListStackResourcesRequest;
import com.amazonaws.services.cloudformation.model.ListStackResourcesResult;
import com.amazonaws.services.cloudformation.model.StackResourceSummary;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.config.AbstractFactoryBean;
import org.springframework.cloud.aws.core.env.stack.ListableStackResourceFactory;
import org.springframework.cloud.aws.core.env.stack.StackResource;
import org.springframework.cloud.aws.core.env.stack.config.AutoDetectingStackNameProvider;
import org.springframework.cloud.aws.core.env.stack.config.StackNameProvider;
import org.springframework.cloud.aws.core.env.stack.config.StaticStackNameProvider;

public class StackResourceRegistryFactoryBean
extends AbstractFactoryBean<ListableStackResourceFactory> {
    private final AmazonCloudFormation amazonCloudFormationClient;
    private final StackNameProvider stackNameProvider;

    public StackResourceRegistryFactoryBean(AmazonCloudFormation amazonCloudFormationClient, StackNameProvider stackNameProvider) {
        this.amazonCloudFormationClient = amazonCloudFormationClient;
        this.stackNameProvider = stackNameProvider;
    }

    public StackResourceRegistryFactoryBean(AmazonCloudFormation amazonCloudFormationClient, String stackName) {
        this(amazonCloudFormationClient, new StaticStackNameProvider(stackName));
    }

    public StackResourceRegistryFactoryBean(AmazonCloudFormation amazonCloudFormationClient) {
        this(amazonCloudFormationClient, new AutoDetectingStackNameProvider(amazonCloudFormationClient));
    }

    public Class<?> getObjectType() {
        return ListableStackResourceFactory.class;
    }

    protected ListableStackResourceFactory createInstance() throws Exception {
        String stackName = this.stackNameProvider.getStackName();
        ListStackResourcesResult listStackResourcesResult = this.amazonCloudFormationClient.listStackResources(new ListStackResourcesRequest().withStackName(stackName));
        List stackResourceSummaries = listStackResourcesResult.getStackResourceSummaries();
        return new StaticStackResourceRegistry(stackName, StackResourceRegistryFactoryBean.convertToStackResourceMappings(stackResourceSummaries));
    }

    private static Map<String, StackResource> convertToStackResourceMappings(List<StackResourceSummary> stackResourceSummaries) {
        HashMap<String, StackResource> stackResourceMappings = new HashMap<String, StackResource>();
        for (StackResourceSummary stackResourceSummary : stackResourceSummaries) {
            stackResourceMappings.put(stackResourceSummary.getLogicalResourceId(), new StackResource(stackResourceSummary.getLogicalResourceId(), stackResourceSummary.getPhysicalResourceId(), stackResourceSummary.getResourceType()));
        }
        return stackResourceMappings;
    }

    private static class StaticStackResourceRegistry
    implements ListableStackResourceFactory {
        private final String stackName;
        private final Map<String, StackResource> stackResourceByLogicalId;

        private StaticStackResourceRegistry(String stackName, Map<String, StackResource> stackResourceByLogicalId) {
            this.stackName = stackName;
            this.stackResourceByLogicalId = stackResourceByLogicalId;
        }

        @Override
        public String getStackName() {
            return this.stackName;
        }

        @Override
        public String lookupPhysicalResourceId(String logicalResourceId) {
            if (this.stackResourceByLogicalId.containsKey(logicalResourceId)) {
                return this.stackResourceByLogicalId.get(logicalResourceId).getPhysicalId();
            }
            return null;
        }

        @Override
        public Collection<StackResource> getAllResources() {
            return this.stackResourceByLogicalId.values();
        }

        @Override
        public Collection<StackResource> resourcesByType(String type) {
            ArrayList<StackResource> result = new ArrayList<StackResource>();
            for (StackResource stackResource : this.stackResourceByLogicalId.values()) {
                if (!stackResource.getType().equals(type)) continue;
                result.add(stackResource);
            }
            return result;
        }
    }
}

