/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.aws.core.io.s3;

import com.amazonaws.services.s3.AmazonS3;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.cloud.aws.core.io.s3.SimpleStorageNameUtils;
import org.springframework.cloud.aws.core.io.s3.SimpleStorageResource;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.task.SyncTaskExecutor;
import org.springframework.core.task.TaskExecutor;
import org.springframework.util.ClassUtils;

public class SimpleStorageResourceLoader
implements ResourceLoader,
InitializingBean {
    private final AmazonS3 amazonS3;
    private final ResourceLoader delegate;
    private TaskExecutor taskExecutor;

    public SimpleStorageResourceLoader(AmazonS3 amazonS3, ResourceLoader delegate) {
        this.amazonS3 = amazonS3;
        this.delegate = delegate;
    }

    public SimpleStorageResourceLoader(AmazonS3 amazonS3, ClassLoader classLoader) {
        this.amazonS3 = amazonS3;
        this.delegate = new DefaultResourceLoader(classLoader);
    }

    public SimpleStorageResourceLoader(AmazonS3 amazonS3) {
        this(amazonS3, ClassUtils.getDefaultClassLoader());
    }

    public void setTaskExecutor(TaskExecutor taskExecutor) {
        this.taskExecutor = taskExecutor;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.taskExecutor == null) {
            this.taskExecutor = new SyncTaskExecutor();
        }
    }

    public Resource getResource(String location) {
        if (SimpleStorageNameUtils.isSimpleStorageResource(location)) {
            return new SimpleStorageResource(this.amazonS3, SimpleStorageNameUtils.getBucketNameFromLocation(location), SimpleStorageNameUtils.getObjectNameFromLocation(location), this.taskExecutor, SimpleStorageNameUtils.getVersionIdFromLocation(location));
        }
        return this.delegate.getResource(location);
    }

    public ClassLoader getClassLoader() {
        return this.delegate.getClassLoader();
    }
}

