/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.aws.core.naming;

import com.amazonaws.regions.Region;
import java.util.Arrays;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class AmazonResourceName {
    private static final String RESOURCE_NAME_DELIMITER = ":";
    private static final String RESOURCE_TYPE_DELIMITER = "/";
    private final String service;
    private final String region;
    private final String account;
    private final String resourceType;
    private final String resourceName;
    private final String actualResourceTypeDelimiter;

    private AmazonResourceName(String service, String region, String account, String resourceType, String resourceName, String actualResourceTypeDelimiter) {
        Assert.notNull((Object)service, (String)"service must not be null");
        Assert.notNull((Object)resourceType, (String)"resourceType must not be null");
        this.service = service;
        this.region = region;
        this.account = account;
        this.resourceType = resourceType;
        this.resourceName = resourceName;
        this.actualResourceTypeDelimiter = actualResourceTypeDelimiter;
    }

    public String getService() {
        return this.service;
    }

    public String getRegion() {
        return this.region;
    }

    public String getAccount() {
        return this.account;
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("arn");
        builder.append(RESOURCE_NAME_DELIMITER);
        builder.append("aws");
        builder.append(RESOURCE_NAME_DELIMITER);
        builder.append(this.service);
        builder.append(RESOURCE_NAME_DELIMITER);
        if (this.region != null) {
            builder.append(this.region);
        }
        builder.append(RESOURCE_NAME_DELIMITER);
        if (this.account != null) {
            builder.append(this.account);
        }
        builder.append(RESOURCE_NAME_DELIMITER);
        builder.append(this.resourceType);
        if (this.resourceName != null) {
            builder.append(this.actualResourceTypeDelimiter);
            builder.append(this.resourceName);
        }
        return builder.toString();
    }

    public static AmazonResourceName fromString(String name) {
        String actualResourceTypeDelimiter;
        Assert.notNull((Object)name, (String)"name must not be null");
        String[] tokens = name.split(RESOURCE_NAME_DELIMITER);
        if (tokens.length < 6 || tokens.length > 7) {
            throw new IllegalArgumentException("Resource name:'" + name + "' is not a valid resource identifier");
        }
        if (!"arn".equals(tokens[0])) {
            throw new IllegalArgumentException("Resource name:'" + name + "' must have a arn qualifier at the beginning");
        }
        if (!"aws".equals(tokens[1])) {
            throw new IllegalArgumentException("Resource name:'" + name + "' must have a aws qualifier");
        }
        if (tokens.length == 6) {
            String[] split = StringUtils.split((String)(tokens = Arrays.copyOf(tokens, 7))[5], (String)RESOURCE_TYPE_DELIMITER);
            if (split != null) {
                tokens[5] = split[0];
                tokens[6] = split[1];
            }
            actualResourceTypeDelimiter = RESOURCE_TYPE_DELIMITER;
        } else {
            actualResourceTypeDelimiter = RESOURCE_NAME_DELIMITER;
        }
        return new AmazonResourceName(tokens[2], AmazonResourceName.trimToNull(tokens[3]), AmazonResourceName.trimToNull(tokens[4]), AmazonResourceName.trimToNull(tokens[5]), AmazonResourceName.trimToNull(tokens[6]), actualResourceTypeDelimiter);
    }

    public static boolean isValidAmazonResourceName(String name) {
        try {
            AmazonResourceName.fromString(name);
            return true;
        }
        catch (IllegalArgumentException ignore) {
            return false;
        }
    }

    private static String trimToNull(String input) {
        return StringUtils.hasText((String)input) ? input : null;
    }

    public static class Builder {
        private String service;
        private String region;
        private String account;
        private String resourceType;
        private String resourceName;
        private String actualResourceTypeDelimiter;

        public Builder withService(String service) {
            this.service = service;
            return this;
        }

        public Builder withRegion(Region region) {
            this.region = region.getName();
            return this;
        }

        public Builder withAccount(String account) {
            this.account = account;
            return this;
        }

        public Builder withResourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public Builder withResourceName(String resourceName) {
            this.resourceName = resourceName;
            return this;
        }

        public Builder withResourceTypeDelimiter(String resourceTypeDelimiter) {
            this.actualResourceTypeDelimiter = resourceTypeDelimiter;
            return this;
        }

        public AmazonResourceName build() {
            return new AmazonResourceName(this.service, this.region, this.account, this.resourceType, this.resourceName, this.actualResourceTypeDelimiter);
        }
    }
}

