/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.aws.core.region;

import com.amazonaws.AmazonClientException;
import com.amazonaws.regions.Region;
import com.amazonaws.regions.RegionUtils;
import com.amazonaws.util.EC2MetadataUtils;
import org.springframework.cloud.aws.core.region.RegionProvider;
import org.springframework.util.Assert;

public class Ec2MetadataRegionProvider
implements RegionProvider {
    @Override
    public Region getRegion() {
        Region currentRegion = this.getCurrentRegion();
        Assert.state((currentRegion != null ? 1 : 0) != 0, (String)"There is no EC2 meta data available, because the application is not running in the EC2 environment. Region detection is only possible if the application is running on a EC2 instance");
        return currentRegion;
    }

    protected Region getCurrentRegion() {
        try {
            EC2MetadataUtils.InstanceInfo instanceInfo = EC2MetadataUtils.getInstanceInfo();
            return instanceInfo != null && instanceInfo.getRegion() != null ? RegionUtils.getRegion((String)instanceInfo.getRegion()) : null;
        }
        catch (AmazonClientException e) {
            return null;
        }
    }
}

