/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.aws.core.io.s3;

import com.amazonaws.services.s3.AmazonS3;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.cloud.aws.core.io.s3.AmazonS3ProxyFactory;
import org.springframework.cloud.aws.core.io.s3.SimpleStorageNameUtils;
import org.springframework.cloud.aws.core.io.s3.SimpleStorageResource;
import org.springframework.core.io.ProtocolResolver;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.task.SyncTaskExecutor;
import org.springframework.core.task.TaskExecutor;

public class SimpleStorageProtocolResolver
implements ProtocolResolver,
InitializingBean {
    private final AmazonS3 amazonS3;
    private TaskExecutor taskExecutor;

    public SimpleStorageProtocolResolver(AmazonS3 amazonS3) {
        this.amazonS3 = AmazonS3ProxyFactory.createProxy(amazonS3);
    }

    public void setTaskExecutor(TaskExecutor taskExecutor) {
        this.taskExecutor = taskExecutor;
    }

    public void afterPropertiesSet() {
        if (this.taskExecutor == null) {
            this.taskExecutor = new SyncTaskExecutor();
        }
    }

    public Resource resolve(String location, ResourceLoader resourceLoader) {
        if (SimpleStorageNameUtils.isSimpleStorageResource(location)) {
            return new SimpleStorageResource(this.amazonS3, SimpleStorageNameUtils.getBucketNameFromLocation(location), SimpleStorageNameUtils.getObjectNameFromLocation(location), this.taskExecutor, SimpleStorageNameUtils.getVersionIdFromLocation(location));
        }
        return null;
    }

    public AmazonS3 getAmazonS3() {
        return this.amazonS3;
    }
}

