/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.aws.core.io.s3;

import com.amazonaws.regions.Region;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.AbortMultipartUploadRequest;
import com.amazonaws.services.s3.model.AmazonS3Exception;
import com.amazonaws.services.s3.model.CompleteMultipartUploadRequest;
import com.amazonaws.services.s3.model.GetObjectMetadataRequest;
import com.amazonaws.services.s3.model.GetObjectRequest;
import com.amazonaws.services.s3.model.InitiateMultipartUploadRequest;
import com.amazonaws.services.s3.model.InitiateMultipartUploadResult;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PartETag;
import com.amazonaws.services.s3.model.UploadPartRequest;
import com.amazonaws.services.s3.model.UploadPartResult;
import com.amazonaws.util.BinaryUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.Future;
import org.springframework.cloud.aws.core.io.s3.AmazonS3ProxyFactory;
import org.springframework.core.io.AbstractResource;
import org.springframework.core.io.WritableResource;
import org.springframework.core.task.TaskExecutor;
import org.springframework.core.task.support.ExecutorServiceAdapter;

public class SimpleStorageResource
extends AbstractResource
implements WritableResource {
    private final String bucketName;
    private final String objectName;
    private final String versionId;
    private final AmazonS3 amazonS3;
    private final TaskExecutor taskExecutor;
    private volatile ObjectMetadata objectMetadata;

    public SimpleStorageResource(AmazonS3 amazonS3, String bucketName, String objectName, TaskExecutor taskExecutor) {
        this(amazonS3, bucketName, objectName, taskExecutor, null);
    }

    public SimpleStorageResource(AmazonS3 amazonS3, String bucketName, String objectName, TaskExecutor taskExecutor, String versionId) {
        this.amazonS3 = AmazonS3ProxyFactory.createProxy(amazonS3);
        this.bucketName = bucketName;
        this.objectName = objectName;
        this.taskExecutor = taskExecutor;
        this.versionId = versionId;
    }

    public String getDescription() {
        StringBuilder builder = new StringBuilder("Amazon s3 resource [bucket='");
        builder.append(this.bucketName);
        builder.append("' and object='");
        builder.append(this.objectName);
        if (this.versionId != null) {
            builder.append("' and versionId='");
            builder.append(this.versionId);
        }
        builder.append("']");
        return builder.toString();
    }

    public InputStream getInputStream() throws IOException {
        GetObjectRequest getObjectRequest = new GetObjectRequest(this.bucketName, this.objectName);
        if (this.versionId != null) {
            getObjectRequest.setVersionId(this.versionId);
        }
        return this.amazonS3.getObject(getObjectRequest).getObjectContent();
    }

    public boolean exists() {
        return this.getObjectMetadata() != null;
    }

    public long contentLength() throws IOException {
        return this.getRequiredObjectMetadata().getContentLength();
    }

    public long lastModified() throws IOException {
        return this.getRequiredObjectMetadata().getLastModified().getTime();
    }

    public String getFilename() throws IllegalStateException {
        return this.objectName;
    }

    public URL getURL() throws IOException {
        Region region = this.amazonS3.getRegion().toAWSRegion();
        return new URL("https", region.getServiceEndpoint("s3"), "/" + this.bucketName + "/" + this.objectName);
    }

    public File getFile() throws IOException {
        throw new UnsupportedOperationException("Amazon S3 resource can not be resolved to java.io.File objects.Use getInputStream() to retrieve the contents of the object!");
    }

    private ObjectMetadata getRequiredObjectMetadata() throws FileNotFoundException {
        ObjectMetadata metadata = this.getObjectMetadata();
        if (metadata == null) {
            StringBuilder builder = new StringBuilder().append("Resource with bucket='").append(this.bucketName).append("' and objectName='").append(this.objectName);
            if (this.versionId != null) {
                builder.append("' and versionId='");
                builder.append(this.versionId);
            }
            builder.append("' not found!");
            throw new FileNotFoundException(builder.toString());
        }
        return metadata;
    }

    public boolean isWritable() {
        return true;
    }

    public OutputStream getOutputStream() throws IOException {
        return new SimpleStorageOutputStream();
    }

    public SimpleStorageResource createRelative(String relativePath) throws IOException {
        String relativeKey = this.objectName + "/" + relativePath;
        return new SimpleStorageResource(this.amazonS3, this.bucketName, relativeKey, this.taskExecutor);
    }

    private ObjectMetadata getObjectMetadata() {
        if (this.objectMetadata == null) {
            try {
                GetObjectMetadataRequest metadataRequest = new GetObjectMetadataRequest(this.bucketName, this.objectName);
                if (this.versionId != null) {
                    metadataRequest.setVersionId(this.versionId);
                }
                this.objectMetadata = this.amazonS3.getObjectMetadata(metadataRequest);
            }
            catch (AmazonS3Exception e) {
                if (e.getStatusCode() == 404 || e.getStatusCode() == 301) {
                    this.objectMetadata = null;
                }
                throw e;
            }
        }
        return this.objectMetadata;
    }

    private class SimpleStorageOutputStream
    extends OutputStream {
        private static final int BUFFER_SIZE = 0x500000;
        private ByteArrayOutputStream currentOutputStream = new ByteArrayOutputStream(0x500000);
        private final Object monitor = new Object();
        private final CompletionService<UploadPartResult> completionService;
        private int partNumberCounter = 1;
        private InitiateMultipartUploadResult multiPartUploadResult;

        SimpleStorageOutputStream() {
            this.completionService = new ExecutorCompletionService<UploadPartResult>((Executor)new ExecutorServiceAdapter(SimpleStorageResource.this.taskExecutor));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(int b) throws IOException {
            Object object = this.monitor;
            synchronized (object) {
                if (this.currentOutputStream.size() == 0x500000) {
                    this.initiateMultiPartIfNeeded();
                    this.completionService.submit(new UploadPartResultCallable(SimpleStorageResource.this.amazonS3, this.currentOutputStream.toByteArray(), this.currentOutputStream.size(), SimpleStorageResource.this.bucketName, SimpleStorageResource.this.objectName, this.multiPartUploadResult.getUploadId(), this.partNumberCounter++, false));
                    this.currentOutputStream.reset();
                }
                this.currentOutputStream.write(b);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            Object object = this.monitor;
            synchronized (object) {
                if (this.currentOutputStream == null) {
                    return;
                }
                if (this.isMultiPartUpload()) {
                    this.finishMultiPartUpload();
                } else {
                    this.finishSimpleUpload();
                }
            }
        }

        private boolean isMultiPartUpload() {
            return this.multiPartUploadResult != null;
        }

        private void finishSimpleUpload() {
            ObjectMetadata objectMetadata = new ObjectMetadata();
            objectMetadata.setContentLength((long)this.currentOutputStream.size());
            byte[] content = this.currentOutputStream.toByteArray();
            try {
                MessageDigest messageDigest = MessageDigest.getInstance("MD5");
                String md5Digest = BinaryUtils.toBase64((byte[])messageDigest.digest(content));
                objectMetadata.setContentMD5(md5Digest);
            }
            catch (NoSuchAlgorithmException e) {
                throw new IllegalStateException("MessageDigest could not be initialized because it uses an unknown algorithm", e);
            }
            SimpleStorageResource.this.amazonS3.putObject(SimpleStorageResource.this.bucketName, SimpleStorageResource.this.objectName, (InputStream)new ByteArrayInputStream(content), objectMetadata);
            this.currentOutputStream = null;
        }

        private void finishMultiPartUpload() throws IOException {
            this.completionService.submit(new UploadPartResultCallable(SimpleStorageResource.this.amazonS3, this.currentOutputStream.toByteArray(), this.currentOutputStream.size(), SimpleStorageResource.this.bucketName, SimpleStorageResource.this.objectName, this.multiPartUploadResult.getUploadId(), this.partNumberCounter, true));
            try {
                List<PartETag> partETags = this.getMultiPartsUploadResults();
                SimpleStorageResource.this.amazonS3.completeMultipartUpload(new CompleteMultipartUploadRequest(this.multiPartUploadResult.getBucketName(), this.multiPartUploadResult.getKey(), this.multiPartUploadResult.getUploadId(), partETags));
            }
            catch (ExecutionException e) {
                this.abortMultiPartUpload();
                throw new IOException("Multi part upload failed ", e.getCause());
            }
            catch (InterruptedException e) {
                this.abortMultiPartUpload();
                Thread.currentThread().interrupt();
            }
            finally {
                this.currentOutputStream = null;
            }
        }

        private void initiateMultiPartIfNeeded() {
            if (this.multiPartUploadResult == null) {
                this.multiPartUploadResult = SimpleStorageResource.this.amazonS3.initiateMultipartUpload(new InitiateMultipartUploadRequest(SimpleStorageResource.this.bucketName, SimpleStorageResource.this.objectName));
            }
        }

        private void abortMultiPartUpload() {
            if (this.isMultiPartUpload()) {
                SimpleStorageResource.this.amazonS3.abortMultipartUpload(new AbortMultipartUploadRequest(this.multiPartUploadResult.getBucketName(), this.multiPartUploadResult.getKey(), this.multiPartUploadResult.getUploadId()));
            }
        }

        private List<PartETag> getMultiPartsUploadResults() throws ExecutionException, InterruptedException {
            ArrayList<PartETag> result = new ArrayList<PartETag>(this.partNumberCounter);
            for (int i = 0; i < this.partNumberCounter; ++i) {
                Future<UploadPartResult> uploadPartResultFuture = this.completionService.take();
                result.add(uploadPartResultFuture.get().getPartETag());
            }
            return result;
        }

        private class UploadPartResultCallable
        implements Callable<UploadPartResult> {
            private final AmazonS3 amazonS3;
            private final int contentLength;
            private final int partNumber;
            private final boolean last;
            private final String bucketName;
            private final String key;
            private final String uploadId;
            private byte[] content;

            private UploadPartResultCallable(AmazonS3 amazon, byte[] content, int writtenDataSize, String bucketName, String key, String uploadId, int partNumber, boolean last) {
                this.amazonS3 = amazon;
                this.content = content;
                this.contentLength = writtenDataSize;
                this.partNumber = partNumber;
                this.last = last;
                this.bucketName = bucketName;
                this.key = key;
                this.uploadId = uploadId;
            }

            @Override
            public UploadPartResult call() throws Exception {
                try {
                    UploadPartResult uploadPartResult = this.amazonS3.uploadPart(new UploadPartRequest().withBucketName(this.bucketName).withKey(this.key).withUploadId(this.uploadId).withInputStream((InputStream)new ByteArrayInputStream(this.content)).withPartNumber(this.partNumber).withLastPart(this.last).withPartSize((long)this.contentLength));
                    return uploadPartResult;
                }
                finally {
                    this.content = null;
                }
            }
        }
    }
}

