/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.aws.core.io.s3;

import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.amazonaws.services.s3.AmazonS3URI;
import java.lang.reflect.Field;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.aop.framework.Advised;
import org.springframework.aop.support.AopUtils;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

public class AmazonS3ClientFactory {
    private static final String CREDENTIALS_PROVIDER_FIELD_NAME = "awsCredentialsProvider";
    private final ConcurrentHashMap<String, AmazonS3> clientCache = new ConcurrentHashMap(Regions.values().length);
    private final Field credentialsProviderField = ReflectionUtils.findField(AmazonS3Client.class, (String)"awsCredentialsProvider");

    public AmazonS3ClientFactory() {
        Assert.notNull((Object)this.credentialsProviderField, (String)"Credentials Provider field not found, this class does not work with the current AWS SDK release");
        ReflectionUtils.makeAccessible((Field)this.credentialsProviderField);
    }

    private static String getRegion(String endpointUrl) {
        Assert.notNull((Object)endpointUrl, (String)"Endpoint Url must not be null");
        try {
            URI uri = new URI(endpointUrl);
            if ("s3.amazonaws.com".equals(uri.getHost())) {
                return Regions.DEFAULT_REGION.getName();
            }
            return new AmazonS3URI(endpointUrl).getRegion();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Malformed URL received for endpoint", e);
        }
    }

    private static AmazonS3Client getAmazonS3ClientFromProxy(AmazonS3 amazonS3) {
        if (AopUtils.isAopProxy((Object)amazonS3)) {
            Advised advised = (Advised)amazonS3;
            Object target = null;
            try {
                target = advised.getTargetSource().getTarget();
            }
            catch (Exception e) {
                return null;
            }
            return target instanceof AmazonS3Client ? (AmazonS3Client)target : null;
        }
        return amazonS3 instanceof AmazonS3Client ? (AmazonS3Client)amazonS3 : null;
    }

    public AmazonS3 createClientForEndpointUrl(AmazonS3 prototype, String endpointUrl) {
        Assert.notNull((Object)prototype, (String)"AmazonS3 must not be null");
        Assert.notNull((Object)endpointUrl, (String)"Endpoint Url must not be null");
        String region = AmazonS3ClientFactory.getRegion(endpointUrl);
        Assert.notNull((Object)region, (String)("Error detecting region from endpoint url:'" + endpointUrl + "'"));
        if (!this.clientCache.containsKey(region)) {
            AmazonS3ClientBuilder amazonS3ClientBuilder = this.buildAmazonS3ForRegion(prototype, region);
            this.clientCache.putIfAbsent(region, (AmazonS3)amazonS3ClientBuilder.build());
        }
        return this.clientCache.get(region);
    }

    private AmazonS3ClientBuilder buildAmazonS3ForRegion(AmazonS3 prototype, String region) {
        AmazonS3ClientBuilder clientBuilder = AmazonS3ClientBuilder.standard();
        AmazonS3Client target = AmazonS3ClientFactory.getAmazonS3ClientFromProxy(prototype);
        if (target != null) {
            AWSCredentialsProvider awsCredentialsProvider = (AWSCredentialsProvider)ReflectionUtils.getField((Field)this.credentialsProviderField, (Object)target);
            clientBuilder.withCredentials(awsCredentialsProvider);
        }
        return (AmazonS3ClientBuilder)clientBuilder.withRegion(region);
    }
}

