/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.aws.core.config;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.client.builder.AwsAsyncClientBuilder;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.regions.Region;
import com.amazonaws.regions.RegionUtils;
import com.amazonaws.regions.Regions;
import java.lang.reflect.Method;
import java.util.concurrent.ExecutorService;
import org.springframework.beans.factory.config.AbstractFactoryBean;
import org.springframework.cloud.aws.core.SpringCloudClientConfiguration;
import org.springframework.cloud.aws.core.region.RegionProvider;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

public class AmazonWebserviceClientFactoryBean<T extends AmazonWebServiceClient>
extends AbstractFactoryBean<T> {
    private final Class<? extends AmazonWebServiceClient> clientClass;
    private final AWSCredentialsProvider credentialsProvider;
    private RegionProvider regionProvider;
    private Region customRegion;
    private ExecutorService executor;

    public AmazonWebserviceClientFactoryBean(Class<T> clientClass, AWSCredentialsProvider credentialsProvider) {
        this.clientClass = clientClass;
        this.credentialsProvider = credentialsProvider;
    }

    public AmazonWebserviceClientFactoryBean(Class<T> clientClass, AWSCredentialsProvider credentialsProvider, RegionProvider regionProvider) {
        this(clientClass, credentialsProvider);
        this.setRegionProvider(regionProvider);
    }

    public Class<?> getObjectType() {
        return this.clientClass;
    }

    protected T createInstance() throws Exception {
        String builderName = this.clientClass.getName() + "Builder";
        Class className = ClassUtils.resolveClassName((String)builderName, (ClassLoader)ClassUtils.getDefaultClassLoader());
        Method method = ClassUtils.getStaticMethod((Class)className, (String)"standard", (Class[])new Class[0]);
        Assert.notNull((Object)method, (String)("Could not find standard() method in class:'" + className.getName() + "'"));
        AwsClientBuilder builder = (AwsClientBuilder)ReflectionUtils.invokeMethod((Method)method, null);
        if (this.executor != null) {
            AwsAsyncClientBuilder asyncBuilder = (AwsAsyncClientBuilder)builder;
            asyncBuilder.withExecutorFactory(() -> this.executor);
        }
        builder.withClientConfiguration(SpringCloudClientConfiguration.getClientConfiguration());
        if (this.credentialsProvider != null) {
            builder.withCredentials(this.credentialsProvider);
        }
        if (this.customRegion != null) {
            builder.withRegion(this.customRegion.getName());
        } else if (this.regionProvider != null) {
            builder.withRegion(this.regionProvider.getRegion().getName());
        } else {
            builder.withRegion(Regions.DEFAULT_REGION);
        }
        return (T)((AmazonWebServiceClient)builder.build());
    }

    public void setRegionProvider(RegionProvider regionProvider) {
        this.regionProvider = regionProvider;
    }

    public void setCustomRegion(String customRegionName) {
        this.customRegion = RegionUtils.getRegion((String)customRegionName);
    }

    public void setExecutor(ExecutorService executor) {
        this.executor = executor;
    }

    protected void destroyInstance(T instance) throws Exception {
        instance.shutdown();
    }
}

