/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.aws.messaging.core.support;

import java.util.Map;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.MessagingException;
import org.springframework.messaging.core.AbstractMessageSendingTemplate;
import org.springframework.messaging.core.CachingDestinationResolverProxy;
import org.springframework.messaging.core.DestinationResolver;
import org.springframework.messaging.core.DestinationResolvingMessageSendingOperations;
import org.springframework.messaging.core.MessagePostProcessor;

public abstract class AbstractMessageChannelMessagingSendingTemplate<D extends MessageChannel>
extends AbstractMessageSendingTemplate<D>
implements DestinationResolvingMessageSendingOperations<D> {
    private final DestinationResolver<String> destinationResolver;

    protected AbstractMessageChannelMessagingSendingTemplate(DestinationResolver<String> destinationResolver) {
        this.destinationResolver = new CachingDestinationResolverProxy(destinationResolver);
    }

    public void setDefaultDestinationName(String defaultDestination) {
        super.setDefaultDestination(this.resolveMessageChannelByLogicalName(defaultDestination));
    }

    protected void doSend(D destination, Message<?> message) {
        destination.send(message);
    }

    public void send(String destinationName, Message<?> message) throws MessagingException {
        D channel = this.resolveMessageChannelByLogicalName(destinationName);
        this.doSend(channel, message);
    }

    public <T> void convertAndSend(String destinationName, T payload) throws MessagingException {
        D channel = this.resolveMessageChannelByLogicalName(destinationName);
        this.convertAndSend(channel, payload);
    }

    public <T> void convertAndSend(String destinationName, T payload, Map<String, Object> headers) throws MessagingException {
        D channel = this.resolveMessageChannelByLogicalName(destinationName);
        this.convertAndSend(channel, payload, headers);
    }

    public <T> void convertAndSend(String destinationName, T payload, MessagePostProcessor postProcessor) throws MessagingException {
        D channel = this.resolveMessageChannelByLogicalName(destinationName);
        this.convertAndSend(channel, payload, postProcessor);
    }

    public <T> void convertAndSend(String destinationName, T payload, Map<String, Object> headers, MessagePostProcessor postProcessor) throws MessagingException {
        D channel = this.resolveMessageChannelByLogicalName(destinationName);
        this.convertAndSend(channel, payload, headers, postProcessor);
    }

    protected D resolveMessageChannelByLogicalName(String destination) {
        String physicalResourceId = (String)this.destinationResolver.resolveDestination(destination);
        return this.resolveMessageChannel(physicalResourceId);
    }

    protected abstract D resolveMessageChannel(String var1);
}

