/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.aws.messaging.endpoint;

import java.util.HashMap;
import org.springframework.cloud.aws.messaging.config.annotation.NotificationSubject;
import org.springframework.cloud.aws.messaging.endpoint.AbstractNotificationMessageHandlerMethodArgumentResolver;
import org.springframework.core.MethodParameter;
import org.springframework.util.ClassUtils;

public class NotificationSubjectHandlerMethodArgumentResolver
extends AbstractNotificationMessageHandlerMethodArgumentResolver {
    public boolean supportsParameter(MethodParameter parameter) {
        return parameter.hasParameterAnnotation(NotificationSubject.class) && ClassUtils.isAssignable(String.class, (Class)parameter.getParameterType());
    }

    @Override
    protected Object doResolverArgumentFromNotificationMessage(HashMap<String, String> content) {
        if (!"Notification".equals(content.get("Type"))) {
            throw new IllegalArgumentException("@NotificationMessage annotated parameters are only allowed for method that receive a notification message.");
        }
        return content.get("Subject");
    }
}

