/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.aws.messaging.config.annotation;

import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.services.sns.AmazonSNS;
import com.amazonaws.services.sns.AmazonSNSClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.aws.context.annotation.ConditionalOnMissingAmazonClient;
import org.springframework.cloud.aws.core.region.RegionProvider;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class SnsConfiguration {
    @Autowired(required=false)
    private AWSCredentialsProvider awsCredentialsProvider;
    @Autowired(required=false)
    private RegionProvider regionProvider;

    @ConditionalOnMissingAmazonClient(value=AmazonSNS.class)
    @Bean
    public AmazonSNS amazonSNS() {
        AmazonSNSClient amazonSNSClient = this.awsCredentialsProvider != null ? new AmazonSNSClient(this.awsCredentialsProvider) : new AmazonSNSClient();
        if (this.regionProvider != null) {
            amazonSNSClient.setRegion(this.regionProvider.getRegion());
        }
        return amazonSNSClient;
    }
}

