/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.aws.messaging.support.destination;

import com.amazonaws.services.sqs.AmazonSQS;
import com.amazonaws.services.sqs.model.CreateQueueRequest;
import com.amazonaws.services.sqs.model.CreateQueueResult;
import com.amazonaws.services.sqs.model.GetQueueUrlRequest;
import com.amazonaws.services.sqs.model.GetQueueUrlResult;
import com.amazonaws.services.sqs.model.QueueDoesNotExistException;
import java.net.URI;
import java.net.URISyntaxException;
import org.springframework.cloud.aws.core.env.ResourceIdResolver;
import org.springframework.messaging.core.DestinationResolutionException;
import org.springframework.messaging.core.DestinationResolver;
import org.springframework.util.Assert;

public class DynamicQueueUrlDestinationResolver
implements DestinationResolver<String> {
    private final AmazonSQS amazonSqs;
    private final ResourceIdResolver resourceIdResolver;
    private boolean autoCreate;

    public DynamicQueueUrlDestinationResolver(AmazonSQS amazonSqs, ResourceIdResolver resourceIdResolver) {
        Assert.notNull((Object)amazonSqs, (String)"amazonSqs must not be null");
        this.amazonSqs = amazonSqs;
        this.resourceIdResolver = resourceIdResolver;
    }

    public DynamicQueueUrlDestinationResolver(AmazonSQS amazonSqs) {
        this(amazonSqs, null);
    }

    public void setAutoCreate(boolean autoCreate) {
        this.autoCreate = autoCreate;
    }

    public String resolveDestination(String name) throws DestinationResolutionException {
        String physicalResourceId;
        if (DynamicQueueUrlDestinationResolver.isValidQueueUrl(name)) {
            return name;
        }
        if (this.resourceIdResolver != null && !name.equals(physicalResourceId = this.resourceIdResolver.resolveToPhysicalResourceId(name))) {
            return physicalResourceId;
        }
        if (this.autoCreate) {
            CreateQueueResult createQueueResult = this.amazonSqs.createQueue(new CreateQueueRequest(name));
            return createQueueResult.getQueueUrl();
        }
        try {
            GetQueueUrlResult getQueueUrlResult = this.amazonSqs.getQueueUrl(new GetQueueUrlRequest(name));
            return getQueueUrlResult.getQueueUrl();
        }
        catch (QueueDoesNotExistException e) {
            throw new DestinationResolutionException(e.getMessage(), (Throwable)e);
        }
    }

    private static boolean isValidQueueUrl(String name) {
        try {
            URI candidate = new URI(name);
            return "http".equals(candidate.getScheme()) || "https".equals(candidate.getScheme());
        }
        catch (URISyntaxException e) {
            return false;
        }
    }
}

