/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.aws.messaging.listener;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.config.BeanExpressionContext;
import org.springframework.beans.factory.config.BeanExpressionResolver;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.cloud.aws.messaging.listener.Acknowledgment;
import org.springframework.cloud.aws.messaging.listener.SqsMessageDeletionPolicy;
import org.springframework.cloud.aws.messaging.listener.annotation.SqsListener;
import org.springframework.cloud.aws.messaging.listener.support.AcknowledgmentHandlerMethodArgumentResolver;
import org.springframework.cloud.aws.messaging.listener.support.VisibilityHandlerMethodArgumentResolver;
import org.springframework.cloud.aws.messaging.support.NotificationMessageArgumentResolver;
import org.springframework.cloud.aws.messaging.support.NotificationSubjectArgumentResolver;
import org.springframework.cloud.aws.messaging.support.converter.ObjectMessageConverter;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessagingException;
import org.springframework.messaging.converter.CompositeMessageConverter;
import org.springframework.messaging.converter.MessageConverter;
import org.springframework.messaging.converter.SimpleMessageConverter;
import org.springframework.messaging.handler.HandlerMethod;
import org.springframework.messaging.handler.annotation.MessageMapping;
import org.springframework.messaging.handler.annotation.support.AnnotationExceptionHandlerMethodResolver;
import org.springframework.messaging.handler.annotation.support.HeaderMethodArgumentResolver;
import org.springframework.messaging.handler.annotation.support.HeadersMethodArgumentResolver;
import org.springframework.messaging.handler.annotation.support.PayloadArgumentResolver;
import org.springframework.messaging.handler.invocation.AbstractExceptionHandlerMethodResolver;
import org.springframework.messaging.handler.invocation.AbstractMethodMessageHandler;
import org.springframework.messaging.handler.invocation.HandlerMethodArgumentResolver;
import org.springframework.messaging.handler.invocation.HandlerMethodReturnValueHandler;
import org.springframework.util.ClassUtils;
import org.springframework.util.comparator.ComparableComparator;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;

public class QueueMessageHandler
extends AbstractMethodMessageHandler<MappingInformation> {
    static final String LOGICAL_RESOURCE_ID = "LogicalResourceId";
    static final String ACKNOWLEDGMENT = "Acknowledgment";
    static final String VISIBILITY = "Visibility";
    private final List<MessageConverter> messageConverters;

    public QueueMessageHandler(List<MessageConverter> messageConverters) {
        this.messageConverters = messageConverters;
    }

    public QueueMessageHandler() {
        this.messageConverters = Collections.emptyList();
    }

    protected List<? extends HandlerMethodArgumentResolver> initArgumentResolvers() {
        ArrayList<Object> resolvers = new ArrayList<Object>(this.getCustomArgumentResolvers());
        resolvers.add(new HeaderMethodArgumentResolver(null, null));
        resolvers.add(new HeadersMethodArgumentResolver());
        resolvers.add(new NotificationSubjectArgumentResolver());
        resolvers.add(new AcknowledgmentHandlerMethodArgumentResolver(ACKNOWLEDGMENT));
        resolvers.add(new VisibilityHandlerMethodArgumentResolver(VISIBILITY));
        CompositeMessageConverter compositeMessageConverter = this.createPayloadArgumentCompositeConverter();
        resolvers.add(new NotificationMessageArgumentResolver((MessageConverter)compositeMessageConverter));
        resolvers.add(new PayloadArgumentResolver((MessageConverter)compositeMessageConverter, (Validator)new NoOpValidator()));
        return resolvers;
    }

    protected List<? extends HandlerMethodReturnValueHandler> initReturnValueHandlers() {
        return new ArrayList(this.getCustomReturnValueHandlers());
    }

    protected boolean isHandler(Class<?> beanType) {
        return true;
    }

    protected MappingInformation getMappingForMethod(Method method, Class<?> handlerType) {
        SqsListener sqsListenerAnnotation = (SqsListener)AnnotationUtils.findAnnotation((Method)method, SqsListener.class);
        if (sqsListenerAnnotation != null && sqsListenerAnnotation.value().length > 0) {
            if (sqsListenerAnnotation.deletionPolicy() == SqsMessageDeletionPolicy.NEVER && this.hasNoAcknowledgmentParameter(method.getParameterTypes())) {
                this.logger.warn((Object)("Listener method '" + method.getName() + "' in type '" + method.getDeclaringClass().getName() + "' has deletion policy 'NEVER' but does not have a parameter of type Acknowledgment."));
            }
            return new MappingInformation(this.resolveDestinationNames(sqsListenerAnnotation.value()), sqsListenerAnnotation.deletionPolicy());
        }
        MessageMapping messageMappingAnnotation = (MessageMapping)AnnotationUtils.findAnnotation((Method)method, MessageMapping.class);
        if (messageMappingAnnotation != null && messageMappingAnnotation.value().length > 0) {
            return new MappingInformation(this.resolveDestinationNames(messageMappingAnnotation.value()), SqsMessageDeletionPolicy.ALWAYS);
        }
        return null;
    }

    private boolean hasNoAcknowledgmentParameter(Class<?>[] parameterTypes) {
        for (Class<?> parameterType : parameterTypes) {
            if (!ClassUtils.isAssignable(Acknowledgment.class, parameterType)) continue;
            return false;
        }
        return true;
    }

    private Set<String> resolveDestinationNames(String[] destinationNames) {
        HashSet<String> result = new HashSet<String>(destinationNames.length);
        for (String destinationName : destinationNames) {
            result.addAll(Arrays.asList(this.resolveName(destinationName)));
        }
        return result;
    }

    private String[] resolveName(String name) {
        if (!(this.getApplicationContext() instanceof ConfigurableApplicationContext)) {
            return QueueMessageHandler.wrapInStringArray(name);
        }
        ConfigurableApplicationContext applicationContext = (ConfigurableApplicationContext)this.getApplicationContext();
        ConfigurableListableBeanFactory configurableBeanFactory = applicationContext.getBeanFactory();
        String placeholdersResolved = configurableBeanFactory.resolveEmbeddedValue(name);
        BeanExpressionResolver exprResolver = configurableBeanFactory.getBeanExpressionResolver();
        if (exprResolver == null) {
            return QueueMessageHandler.wrapInStringArray(name);
        }
        Object result = exprResolver.evaluate(placeholdersResolved, new BeanExpressionContext((ConfigurableBeanFactory)configurableBeanFactory, null));
        if (result instanceof String[]) {
            return (String[])result;
        }
        if (result != null) {
            return QueueMessageHandler.wrapInStringArray(result);
        }
        return QueueMessageHandler.wrapInStringArray(name);
    }

    private static String[] wrapInStringArray(Object valueToWrap) {
        return new String[]{valueToWrap.toString()};
    }

    protected Set<String> getDirectLookupDestinations(MappingInformation mapping) {
        return mapping.getLogicalResourceIds();
    }

    protected String getDestination(Message<?> message) {
        return message.getHeaders().get((Object)LOGICAL_RESOURCE_ID).toString();
    }

    protected MappingInformation getMatchingMapping(MappingInformation mapping, Message<?> message) {
        if (mapping.getLogicalResourceIds().contains(this.getDestination(message))) {
            return mapping;
        }
        return null;
    }

    protected Comparator<MappingInformation> getMappingComparator(Message<?> message) {
        return new ComparableComparator();
    }

    protected AbstractExceptionHandlerMethodResolver createExceptionHandlerMethodResolverFor(Class<?> beanType) {
        return new AnnotationExceptionHandlerMethodResolver(beanType);
    }

    protected void handleNoMatch(Set<MappingInformation> ts, String lookupDestination, Message<?> message) {
        this.logger.warn((Object)"No match found");
    }

    protected void processHandlerMethodException(HandlerMethod handlerMethod, Exception ex, Message<?> message) {
        super.processHandlerMethodException(handlerMethod, ex, message);
        throw new MessagingException("An exception occurred while invoking the handler method", (Throwable)ex);
    }

    private CompositeMessageConverter createPayloadArgumentCompositeConverter() {
        ArrayList<MessageConverter> payloadArgumentConverters = new ArrayList<MessageConverter>(this.messageConverters);
        ObjectMessageConverter objectMessageConverter = new ObjectMessageConverter();
        objectMessageConverter.setStrictContentTypeMatch(true);
        payloadArgumentConverters.add((MessageConverter)objectMessageConverter);
        payloadArgumentConverters.add((MessageConverter)new SimpleMessageConverter());
        return new CompositeMessageConverter(payloadArgumentConverters);
    }

    private static final class NoOpValidator
    implements Validator {
        private NoOpValidator() {
        }

        public boolean supports(Class<?> clazz) {
            return false;
        }

        public void validate(Object target, Errors errors) {
        }
    }

    protected static class MappingInformation
    implements Comparable<MappingInformation> {
        private final Set<String> logicalResourceIds;
        private final SqsMessageDeletionPolicy deletionPolicy;

        public MappingInformation(Set<String> logicalResourceIds, SqsMessageDeletionPolicy deletionPolicy) {
            this.logicalResourceIds = Collections.unmodifiableSet(logicalResourceIds);
            this.deletionPolicy = deletionPolicy;
        }

        public Set<String> getLogicalResourceIds() {
            return this.logicalResourceIds;
        }

        public SqsMessageDeletionPolicy getDeletionPolicy() {
            return this.deletionPolicy;
        }

        @Override
        public int compareTo(MappingInformation o) {
            return 0;
        }

        public String toString() {
            return this.logicalResourceIds.stream().collect(Collectors.joining(", "));
        }
    }
}

