/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.aws.messaging.config;

import com.amazonaws.services.sqs.AmazonSQS;
import com.amazonaws.services.sqs.AmazonSQSAsync;
import org.springframework.cloud.aws.core.env.ResourceIdResolver;
import org.springframework.cloud.aws.messaging.listener.QueueMessageHandler;
import org.springframework.cloud.aws.messaging.listener.SimpleMessageListenerContainer;
import org.springframework.core.task.AsyncTaskExecutor;
import org.springframework.messaging.core.DestinationResolver;
import org.springframework.util.Assert;

public class SimpleMessageListenerContainerFactory {
    private AsyncTaskExecutor taskExecutor;
    private Integer maxNumberOfMessages;
    private Integer visibilityTimeout;
    private Integer waitTimeOut;
    private boolean autoStartup = true;
    private AmazonSQSAsync amazonSqs;
    private QueueMessageHandler queueMessageHandler;
    private ResourceIdResolver resourceIdResolver;
    private DestinationResolver<String> destinationResolver;
    private Long backOffTime;

    public void setTaskExecutor(AsyncTaskExecutor taskExecutor) {
        this.taskExecutor = taskExecutor;
    }

    public void setMaxNumberOfMessages(Integer maxNumberOfMessages) {
        this.maxNumberOfMessages = maxNumberOfMessages;
    }

    public void setVisibilityTimeout(Integer visibilityTimeout) {
        this.visibilityTimeout = visibilityTimeout;
    }

    public void setWaitTimeOut(Integer waitTimeOut) {
        this.waitTimeOut = waitTimeOut;
    }

    public void setAutoStartup(boolean autoStartup) {
        this.autoStartup = autoStartup;
    }

    public AmazonSQS getAmazonSqs() {
        return this.amazonSqs;
    }

    public void setAmazonSqs(AmazonSQSAsync amazonSqs) {
        Assert.notNull((Object)amazonSqs, (String)"amazonSqs must not be null");
        this.amazonSqs = amazonSqs;
    }

    public QueueMessageHandler getQueueMessageHandler() {
        return this.queueMessageHandler;
    }

    public void setQueueMessageHandler(QueueMessageHandler messageHandler) {
        Assert.notNull((Object)((Object)messageHandler), (String)"messageHandler must not be null");
        this.queueMessageHandler = messageHandler;
    }

    public ResourceIdResolver getResourceIdResolver() {
        return this.resourceIdResolver;
    }

    public void setResourceIdResolver(ResourceIdResolver resourceIdResolver) {
        this.resourceIdResolver = resourceIdResolver;
    }

    public void setDestinationResolver(DestinationResolver<String> destinationResolver) {
        this.destinationResolver = destinationResolver;
    }

    public Long getBackOffTime() {
        return this.backOffTime;
    }

    public void setBackOffTime(Long backOffTime) {
        this.backOffTime = backOffTime;
    }

    public SimpleMessageListenerContainer createSimpleMessageListenerContainer() {
        Assert.notNull((Object)this.amazonSqs, (String)"amazonSqs must not be null");
        SimpleMessageListenerContainer simpleMessageListenerContainer = new SimpleMessageListenerContainer();
        simpleMessageListenerContainer.setAmazonSqs(this.amazonSqs);
        simpleMessageListenerContainer.setAutoStartup(this.autoStartup);
        if (this.taskExecutor != null) {
            simpleMessageListenerContainer.setTaskExecutor(this.taskExecutor);
        }
        if (this.maxNumberOfMessages != null) {
            simpleMessageListenerContainer.setMaxNumberOfMessages(this.maxNumberOfMessages);
        }
        if (this.visibilityTimeout != null) {
            simpleMessageListenerContainer.setVisibilityTimeout(this.visibilityTimeout);
        }
        if (this.waitTimeOut != null) {
            simpleMessageListenerContainer.setWaitTimeOut(this.waitTimeOut);
        }
        if (this.resourceIdResolver != null) {
            simpleMessageListenerContainer.setResourceIdResolver(this.resourceIdResolver);
        }
        if (this.destinationResolver != null) {
            simpleMessageListenerContainer.setDestinationResolver((DestinationResolver)this.destinationResolver);
        }
        if (this.backOffTime != null) {
            simpleMessageListenerContainer.setBackOffTime(this.backOffTime);
        }
        return simpleMessageListenerContainer;
    }
}

