/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.bus.jackson;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.cloud.bus.jackson.BusJacksonMessageConverter;
import org.springframework.cloud.bus.jackson.RemoteApplicationEventScan;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class RemoteApplicationEventRegistrar
implements ImportBeanDefinitionRegistrar {
    private static final String PACKAGES_TO_SCAN = "packagesToScan";
    private static final String BUS_JSON_CONVERTER = "busJsonConverter";

    public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
        Map componentScan = importingClassMetadata.getAnnotationAttributes(RemoteApplicationEventScan.class.getName(), false);
        HashSet<String> basePackages = new HashSet<String>();
        for (String pkg : (String[])componentScan.get("value")) {
            if (!StringUtils.hasText((String)pkg)) continue;
            basePackages.add(pkg);
        }
        for (String pkg : (String[])componentScan.get("basePackages")) {
            if (!StringUtils.hasText((String)pkg)) continue;
            basePackages.add(pkg);
        }
        for (Class clazz : (Class[])componentScan.get("basePackageClasses")) {
            basePackages.add(ClassUtils.getPackageName((Class)clazz));
        }
        if (basePackages.isEmpty()) {
            basePackages.add(ClassUtils.getPackageName((String)importingClassMetadata.getClassName()));
        }
        if (!registry.containsBeanDefinition(BUS_JSON_CONVERTER)) {
            BeanDefinitionBuilder beanDefinitionBuilder = BeanDefinitionBuilder.genericBeanDefinition(BusJacksonMessageConverter.class);
            beanDefinitionBuilder.addPropertyValue(PACKAGES_TO_SCAN, (Object)basePackages.toArray(new String[basePackages.size()]));
            AbstractBeanDefinition beanDefinition = beanDefinitionBuilder.getBeanDefinition();
            BeanDefinitionHolder holder = new BeanDefinitionHolder((BeanDefinition)beanDefinition, BUS_JSON_CONVERTER);
            BeanDefinitionReaderUtils.registerBeanDefinition((BeanDefinitionHolder)holder, (BeanDefinitionRegistry)registry);
        } else {
            basePackages.addAll(this.getEarlierPackagesToScan(registry));
            registry.getBeanDefinition(BUS_JSON_CONVERTER).getPropertyValues().addPropertyValue(PACKAGES_TO_SCAN, (Object)basePackages.toArray(new String[basePackages.size()]));
        }
    }

    private Set<String> getEarlierPackagesToScan(BeanDefinitionRegistry registry) {
        if (registry.containsBeanDefinition(BUS_JSON_CONVERTER) && registry.getBeanDefinition(BUS_JSON_CONVERTER).getPropertyValues().get(PACKAGES_TO_SCAN) != null) {
            String[] earlierValues = (String[])registry.getBeanDefinition(BUS_JSON_CONVERTER).getPropertyValues().get(PACKAGES_TO_SCAN);
            return new HashSet<String>(Arrays.asList(earlierValues));
        }
        return new HashSet<String>();
    }
}

