/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.bus.rsocket;

import io.rsocket.routing.client.spring.RoutingClientProperties;
import io.rsocket.routing.common.Key;
import io.rsocket.routing.common.WellKnownKey;
import java.util.HashMap;
import java.util.Map;
import org.springframework.cloud.bus.ServiceMatcher;
import org.springframework.cloud.bus.event.RemoteApplicationEvent;
import org.springframework.cloud.bus.rsocket.RSocketRequesterBusBridge;
import org.springframework.util.AntPathMatcher;

public class RSocketServiceMatcher
implements ServiceMatcher {
    private final String busId;
    private final RoutingClientProperties properties;
    private final AntPathMatcher antPathMatcher = new AntPathMatcher();
    private final Map<Key, String> localTags = new HashMap<Key, String>();

    public RSocketServiceMatcher(String busId, RoutingClientProperties properties) {
        this.busId = busId;
        this.properties = properties;
        this.convertLocalTags(properties);
    }

    public boolean isFromSelf(RemoteApplicationEvent event) {
        String originService = event.getOriginService();
        String serviceId = this.getBusId();
        return this.antPathMatcher.match(originService, serviceId);
    }

    public boolean isForSelf(RemoteApplicationEvent event) {
        Map<Key, String> tags = RSocketRequesterBusBridge.getTagsFromDestination(event.getDestinationService());
        for (Map.Entry<Key, String> entry : tags.entrySet()) {
            String existingValue = this.localTags.get(entry.getKey());
            if (existingValue != null && existingValue.equals(entry.getValue())) continue;
            return false;
        }
        return true;
    }

    private void convertLocalTags(RoutingClientProperties properties) {
        properties.getTags().forEach((key, value) -> {
            if (key.getWellKnownKey() != null) {
                this.localTags.put(Key.of((WellKnownKey)key.getWellKnownKey()), (String)value);
            } else {
                this.localTags.put(Key.of((String)key.getKey()), (String)value);
            }
        });
        this.localTags.put(Key.of((WellKnownKey)WellKnownKey.SERVICE_NAME), properties.getServiceName());
    }

    public String getBusId() {
        return this.busId;
    }
}

