/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.cluster.leader;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.cluster.leader.AbstractCandidate;
import org.springframework.cloud.cluster.leader.Context;

public class DefaultCandidate
extends AbstractCandidate {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private volatile Context leaderContext;

    public DefaultCandidate() {
    }

    public DefaultCandidate(String id, String role) {
        super(id, role);
    }

    @Override
    public void onGranted(Context ctx) {
        this.logger.info("{} has been granted leadership; context: {}", (Object)this, (Object)ctx);
        this.leaderContext = ctx;
    }

    @Override
    public void onRevoked(Context ctx) {
        this.logger.info("{} leadership has been revoked", (Object)this, (Object)ctx);
    }

    public void yieldLeadership() {
        if (this.leaderContext != null) {
            this.leaderContext.yield();
        }
    }

    public String toString() {
        return String.format("DefaultCandidate{role=%s, id=%s}", this.getRole(), this.getId());
    }
}

