/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.cluster.leader.event;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.cluster.leader.event.AbstractLeaderEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.util.StringUtils;

public class LoggingListener
implements ApplicationListener<AbstractLeaderEvent> {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Level level;

    public LoggingListener() {
        this.level = Level.DEBUG;
    }

    public LoggingListener(String level) {
        try {
            this.level = Level.valueOf(level.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Invalid log level '" + level + "'. The (case-insensitive) supported values are: " + StringUtils.arrayToCommaDelimitedString((Object[])Level.values()));
        }
    }

    public void onApplicationEvent(AbstractLeaderEvent event) {
        switch (this.level) {
            case ERROR: {
                if (!this.logger.isErrorEnabled()) break;
                this.logger.error(event.toString());
                break;
            }
            case WARN: {
                if (!this.logger.isWarnEnabled()) break;
                this.logger.warn(event.toString());
                break;
            }
            case INFO: {
                if (!this.logger.isInfoEnabled()) break;
                this.logger.info(event.toString());
                break;
            }
            case DEBUG: {
                if (!this.logger.isDebugEnabled()) break;
                this.logger.debug(event.toString());
                break;
            }
            case TRACE: {
                if (!this.logger.isTraceEnabled()) break;
                this.logger.trace(event.toString());
            }
        }
    }

    private static enum Level {
        ERROR,
        WARN,
        INFO,
        DEBUG,
        TRACE;

    }
}

