/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.cluster.lock.support;

import org.springframework.cloud.cluster.lock.DistributedLock;
import org.springframework.cloud.cluster.lock.LockRegistry;
import org.springframework.cloud.cluster.lock.LockService;
import org.springframework.cloud.cluster.lock.LockServiceLocator;
import org.springframework.cloud.cluster.lock.LockingException;
import org.springframework.util.Assert;

public class DefaultLockRegistry
implements LockRegistry {
    private final LockServiceLocator lockServiceLocator;

    public DefaultLockRegistry(LockServiceLocator lockServiceLocator) {
        Assert.notNull((Object)lockServiceLocator, (String)"Lock service locator must be set");
        this.lockServiceLocator = lockServiceLocator;
    }

    @Override
    public DistributedLock get(String lockKey) {
        LockService service = this.lockServiceLocator.locate(lockKey);
        if (service == null) {
            throw new LockingException("Unable to find lockservice for key=[" + lockKey + "]");
        }
        return service.obtain(lockKey);
    }
}

