/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.cluster.lock.support;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.springframework.cloud.cluster.lock.LockService;
import org.springframework.cloud.cluster.lock.LockServiceLocator;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.Assert;
import org.springframework.util.PathMatcher;

public class DefaultLockServiceLocator
implements LockServiceLocator {
    private final List<PathMapping> mappings = new CopyOnWriteArrayList<PathMapping>();
    private final PathMatcher matcher = new AntPathMatcher();
    private final LockService fallback;

    public DefaultLockServiceLocator(LockService fallback) {
        Assert.notNull((Object)fallback, (String)"Fallback lock service must be set");
        this.fallback = fallback;
    }

    @Override
    public LockService locate(String lockKey) {
        LockService match = this.match(lockKey);
        return match != null ? match : this.fallback;
    }

    public void addMapping(String path, LockService lockService) {
        Assert.notNull((Object)lockService, (String)"Lock service must not be null");
        this.mappings.add(new PathMapping(path, lockService));
    }

    private LockService match(String path) {
        for (PathMapping m : this.mappings) {
            if (!this.matcher.match(m.getPath(), path)) continue;
            return m.getLockService();
        }
        return null;
    }

    private static class PathMapping {
        private String path;
        private LockService lockService;

        public PathMapping(String path, LockService lockService) {
            this.path = path;
            this.lockService = lockService;
        }

        public String getPath() {
            return this.path;
        }

        public LockService getLockService() {
            return this.lockService;
        }
    }
}

