/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.cluster.lock.support;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import org.springframework.cloud.cluster.lock.support.AbstractDistributedLock;
import org.springframework.util.Assert;

public class DelegatingDistributedLock
extends AbstractDistributedLock {
    private final Lock lock;

    public DelegatingDistributedLock(String lockKey, Lock lock) {
        super(lockKey);
        Assert.notNull((Object)lock, (String)"Lock must be set");
        this.lock = lock;
    }

    @Override
    public void lock() {
        this.lock.lock();
    }

    @Override
    public void lockInterruptibly() throws InterruptedException {
        this.lock.lockInterruptibly();
    }

    @Override
    public boolean tryLock() {
        return this.lock.tryLock();
    }

    @Override
    public boolean tryLock(long time, TimeUnit unit) throws InterruptedException {
        return this.lock.tryLock(time, unit);
    }

    @Override
    public void unlock() {
        this.lock.unlock();
    }

    @Override
    public Condition newCondition() {
        return this.lock.newCondition();
    }
}

