/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.client.discovery.health;

import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.Status;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.cloud.client.discovery.event.InstanceRegisteredEvent;
import org.springframework.cloud.client.discovery.health.DiscoveryHealthIndicator;
import org.springframework.context.ApplicationListener;
import org.springframework.core.Ordered;

public class DiscoveryClientHealthIndicator
implements DiscoveryHealthIndicator,
Ordered,
ApplicationListener<InstanceRegisteredEvent> {
    private static final Log log = LogFactory.getLog(DiscoveryClientHealthIndicator.class);
    private AtomicBoolean discoveryInitialized = new AtomicBoolean(false);
    private int order = Integer.MIN_VALUE;
    private DiscoveryClient discoveryClient;

    public DiscoveryClientHealthIndicator(DiscoveryClient discoveryClient) {
        this.discoveryClient = discoveryClient;
    }

    public void onApplicationEvent(InstanceRegisteredEvent event) {
        if (this.discoveryInitialized.compareAndSet(false, true)) {
            log.debug((Object)"Discovery Client has been initialized");
        }
    }

    @Override
    public Health health() {
        Health.Builder builder = new Health.Builder();
        if (this.discoveryInitialized.get()) {
            try {
                List<String> services = this.discoveryClient.getServices();
                builder.status(new Status("UP", this.discoveryClient.description())).withDetail("services", services);
            }
            catch (Exception e) {
                log.error((Object)"Error", (Throwable)e);
                builder.down(e);
            }
        } else {
            builder.status(new Status(Status.UNKNOWN.getCode(), "Discovery Client not initialized"));
        }
        return builder.build();
    }

    @Override
    public String getName() {
        return "discoveryClient";
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }
}

