/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.commons.util;

import org.springframework.core.env.PropertyResolver;
import org.springframework.util.StringUtils;

public final class IdUtils {
    private static final String SEPARATOR = ":";

    private IdUtils() {
        throw new IllegalStateException("Can't instantiate a utility class");
    }

    public static String getDefaultInstanceId(PropertyResolver resolver) {
        return IdUtils.getDefaultInstanceId(resolver, true);
    }

    public static String getDefaultInstanceId(PropertyResolver resolver, boolean includeHostname) {
        String vcapInstanceId = resolver.getProperty("vcap.application.instance_id");
        if (StringUtils.hasText((String)vcapInstanceId)) {
            return vcapInstanceId;
        }
        String hostname = null;
        if (includeHostname) {
            hostname = resolver.getProperty("spring.cloud.client.hostname");
        }
        String appName = resolver.getProperty("spring.application.name");
        String namePart = IdUtils.combineParts(hostname, SEPARATOR, appName);
        String indexPart = resolver.getProperty("spring.application.instance_id", resolver.getProperty("server.port"));
        return IdUtils.combineParts(namePart, SEPARATOR, indexPart);
    }

    public static String combineParts(String firstPart, String separator, String secondPart) {
        String combined = null;
        if (firstPart != null && secondPart != null) {
            combined = firstPart + separator + secondPart;
        } else if (firstPart != null) {
            combined = firstPart;
        } else if (secondPart != null) {
            combined = secondPart;
        }
        return combined;
    }
}

