/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.client.discovery.simple;

import java.net.URI;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.cloud.client.DefaultServiceInstance;
import org.springframework.cloud.client.ServiceInstance;

@ConfigurationProperties(prefix="spring.cloud.discovery.client.simple")
public class SimpleDiscoveryProperties {
    private Map<String, List<DefaultServiceInstance>> instances = new HashMap<String, List<DefaultServiceInstance>>();
    private DefaultServiceInstance local = new DefaultServiceInstance(null, null, null, 0, false);
    private int order = 0;

    public Map<String, List<DefaultServiceInstance>> getInstances() {
        return this.instances;
    }

    public void setInstances(Map<String, List<DefaultServiceInstance>> instances) {
        this.instances = instances;
    }

    public DefaultServiceInstance getLocal() {
        return this.local;
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    @PostConstruct
    public void init() {
        for (String key : this.instances.keySet()) {
            for (DefaultServiceInstance instance : this.instances.get(key)) {
                instance.setServiceId(key);
            }
        }
    }

    public void setInstance(String serviceId, String host, int port) {
        this.local = new DefaultServiceInstance(null, serviceId, host, port, false);
    }

    @Deprecated
    public static class SimpleServiceInstance
    implements ServiceInstance {
        private URI uri;
        private String host;
        private int port;
        private boolean secure;
        private Map<String, String> metadata = new LinkedHashMap<String, String>();
        private String instanceId;
        private String serviceId;

        public SimpleServiceInstance() {
        }

        public SimpleServiceInstance(URI uri) {
            this.setUri(uri);
        }

        @Override
        public String getInstanceId() {
            return this.instanceId;
        }

        public void setInstanceId(String id) {
            this.instanceId = id;
        }

        @Override
        public String getServiceId() {
            return this.serviceId;
        }

        public void setServiceId(String id) {
            this.serviceId = id;
        }

        @Override
        public String getHost() {
            return this.host;
        }

        @Override
        public int getPort() {
            return this.port;
        }

        @Override
        public boolean isSecure() {
            return this.secure;
        }

        @Override
        public URI getUri() {
            return this.uri;
        }

        public void setUri(URI uri) {
            this.uri = uri;
            this.host = this.uri.getHost();
            this.port = this.uri.getPort();
            String scheme = this.uri.getScheme();
            if ("https".equals(scheme)) {
                this.secure = true;
            }
        }

        @Override
        public Map<String, String> getMetadata() {
            return this.metadata;
        }
    }
}

