/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.bootstrap.encrypt;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.Ordered;
import org.springframework.core.env.CompositePropertySource;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.security.crypto.encrypt.TextEncryptor;

public class EnvironmentDecryptApplicationInitializer
implements ApplicationContextInitializer<ConfigurableApplicationContext>,
Ordered {
    private static Log logger = LogFactory.getLog(EnvironmentDecryptApplicationInitializer.class);
    private int order = -2147483633;
    private TextEncryptor encryptor;
    private boolean failOnError = true;

    public EnvironmentDecryptApplicationInitializer(TextEncryptor encryptor) {
        this.encryptor = encryptor;
    }

    public void setFailOnError(boolean failOnError) {
        this.failOnError = failOnError;
    }

    public int getOrder() {
        return this.order;
    }

    public void initialize(ConfigurableApplicationContext applicationContext) {
        ConfigurableEnvironment environment = applicationContext.getEnvironment();
        LinkedHashMap<String, Object> overrides = new LinkedHashMap<String, Object>();
        for (PropertySource source : environment.getPropertySources()) {
            this.decrypt(source, overrides);
        }
        if (!overrides.isEmpty()) {
            environment.getPropertySources().addFirst((PropertySource)new MapPropertySource("decrypted", overrides));
        }
    }

    private void decrypt(PropertySource<?> source, Map<String, Object> overrides) {
        block10: {
            block9: {
                if (!(source instanceof EnumerablePropertySource)) break block9;
                EnumerablePropertySource enumerable = (EnumerablePropertySource)source;
                String[] stringArray = enumerable.getPropertyNames();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String key = stringArray[n2];
                    String value = source.getProperty(key).toString();
                    if (value.startsWith("{cipher}")) {
                        value = value.substring("{cipher}".length());
                        try {
                            value = this.encryptor.decrypt(value);
                            if (logger.isDebugEnabled()) {
                                logger.debug((Object)("Decrypted: key=" + key));
                            }
                        }
                        catch (Exception e) {
                            String message = "Cannot decrypt: key=" + key;
                            if (this.failOnError) {
                                throw new IllegalStateException(message, e);
                            }
                            if (logger.isDebugEnabled()) {
                                logger.warn((Object)message, (Throwable)e);
                            } else {
                                logger.warn((Object)message);
                            }
                            value = "";
                        }
                        overrides.put(key, value);
                    }
                    ++n2;
                }
                break block10;
            }
            if (!(source instanceof CompositePropertySource)) break block10;
            for (PropertySource nested : ((CompositePropertySource)source).getPropertySources()) {
                this.decrypt(nested, overrides);
            }
        }
    }
}

