/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.client;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.bootstrap.config.PropertySourceLocator;
import org.springframework.cloud.config.client.ConfigClientProperties;
import org.springframework.cloud.config.client.ConfigClientStateHolder;
import org.springframework.cloud.config.environment.Environment;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.CompositePropertySource;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpRequest;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.retry.annotation.Retryable;
import org.springframework.util.Base64Utils;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.HttpServerErrorException;
import org.springframework.web.client.RestTemplate;

@Order(value=0)
public class ConfigServicePropertySourceLocator
implements PropertySourceLocator {
    private static Log logger = LogFactory.getLog(ConfigServicePropertySourceLocator.class);
    private RestTemplate restTemplate;
    private ConfigClientProperties defaultProperties;

    public ConfigServicePropertySourceLocator(ConfigClientProperties defaultProperties) {
        this.defaultProperties = defaultProperties;
    }

    @Retryable(interceptor="configServerRetryInterceptor")
    public PropertySource<?> locate(org.springframework.core.env.Environment environment) {
        ConfigClientProperties properties = this.defaultProperties.override(environment);
        CompositePropertySource composite = new CompositePropertySource("configService");
        RestTemplate restTemplate = this.restTemplate == null ? this.getSecureRestTemplate(properties) : this.restTemplate;
        Throwable error = null;
        String errorBody = null;
        logger.info((Object)("Fetching config from server at: " + properties.getRawUri()));
        try {
            String[] labels = new String[]{""};
            if (StringUtils.hasText((String)properties.getLabel())) {
                labels = StringUtils.commaDelimitedListToStringArray((String)properties.getLabel());
            }
            String state = ConfigClientStateHolder.getState();
            for (String label : labels) {
                Environment result = this.getRemoteEnvironment(restTemplate, properties, label.trim(), state);
                if (result == null) continue;
                logger.info((Object)String.format("Located environment: name=%s, profiles=%s, label=%s, version=%s, state=%s", result.getName(), result.getProfiles() == null ? "" : Arrays.asList(result.getProfiles()), result.getLabel(), result.getVersion(), result.getState()));
                for (org.springframework.cloud.config.environment.PropertySource source : result.getPropertySources()) {
                    Map<?, ?> map = source.getSource();
                    composite.addPropertySource((PropertySource)new MapPropertySource(source.getName(), map));
                }
                if (StringUtils.hasText((String)result.getState()) || StringUtils.hasText((String)result.getVersion())) {
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    this.putValue(map, "config.client.state", result.getState());
                    this.putValue(map, "config.client.version", result.getVersion());
                    composite.addFirstPropertySource((PropertySource)new MapPropertySource("configClient", map));
                }
                return composite;
            }
        }
        catch (HttpServerErrorException e) {
            error = e;
            if (MediaType.APPLICATION_JSON.includes(e.getResponseHeaders().getContentType())) {
                errorBody = e.getResponseBodyAsString();
            }
        }
        catch (Exception e) {
            error = e;
        }
        if (properties.isFailFast()) {
            throw new IllegalStateException("Could not locate PropertySource and the fail fast property is set, failing", error);
        }
        logger.warn((Object)("Could not locate PropertySource: " + (errorBody == null ? (error == null ? "label not found" : error.getMessage()) : errorBody)));
        return null;
    }

    private void putValue(HashMap<String, Object> map, String key, String value) {
        if (StringUtils.hasText((String)value)) {
            map.put(key, value);
        }
    }

    private Environment getRemoteEnvironment(RestTemplate restTemplate, ConfigClientProperties properties, String label, String state) {
        ResponseEntity response;
        block6: {
            String path = "/{name}/{profile}";
            String name = properties.getName();
            String profile = properties.getProfile();
            String token = properties.getToken();
            String uri = properties.getRawUri();
            Object[] args = new String[]{name, profile};
            if (StringUtils.hasText((String)label)) {
                args = new String[]{name, profile, label};
                path = path + "/{label}";
            }
            response = null;
            try {
                HttpHeaders headers = new HttpHeaders();
                if (StringUtils.hasText((String)token)) {
                    headers.add("X-Config-Token", token);
                }
                if (StringUtils.hasText((String)state)) {
                    headers.add("X-Config-State", state);
                }
                HttpEntity entity = new HttpEntity((Object)null, (MultiValueMap)headers);
                response = restTemplate.exchange(uri + path, HttpMethod.GET, entity, Environment.class, args);
            }
            catch (HttpClientErrorException e) {
                if (e.getStatusCode() == HttpStatus.NOT_FOUND) break block6;
                throw e;
            }
        }
        if (response == null || response.getStatusCode() != HttpStatus.OK) {
            return null;
        }
        Environment result = (Environment)response.getBody();
        return result;
    }

    public void setRestTemplate(RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
    }

    private RestTemplate getSecureRestTemplate(ConfigClientProperties client) {
        SimpleClientHttpRequestFactory requestFactory = new SimpleClientHttpRequestFactory();
        requestFactory.setReadTimeout(185000);
        RestTemplate template = new RestTemplate((ClientHttpRequestFactory)requestFactory);
        String password = client.getPassword();
        String authorization = client.getAuthorization();
        if (password != null && authorization != null) {
            throw new IllegalStateException("You must set either 'password' or 'authorization'");
        }
        if (password != null) {
            template.setInterceptors(Arrays.asList(new BasicAuthorizationInterceptor(client.getUsername(), password)));
        } else if (authorization != null) {
            template.setInterceptors(Arrays.asList(new GenericAuthorization(authorization)));
        }
        return template;
    }

    private static class GenericAuthorization
    implements ClientHttpRequestInterceptor {
        private final String authorizationToken;

        public GenericAuthorization(String authorizationToken) {
            this.authorizationToken = authorizationToken == null ? "" : authorizationToken;
        }

        public ClientHttpResponse intercept(HttpRequest request, byte[] body, ClientHttpRequestExecution execution) throws IOException {
            request.getHeaders().add("Authorization", this.authorizationToken);
            return execution.execute(request, body);
        }
    }

    private static class BasicAuthorizationInterceptor
    implements ClientHttpRequestInterceptor {
        private final String username;
        private final String password;

        public BasicAuthorizationInterceptor(String username, String password) {
            this.username = username;
            this.password = password == null ? "" : password;
        }

        public ClientHttpResponse intercept(HttpRequest request, byte[] body, ClientHttpRequestExecution execution) throws IOException {
            byte[] token = Base64Utils.encode((byte[])(this.username + ":" + this.password).getBytes());
            request.getHeaders().add("Authorization", "Basic " + new String(token));
            return execution.execute(request, body);
        }
    }
}

