/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.client;

import java.util.ArrayList;
import org.springframework.boot.actuate.health.AbstractHealthIndicator;
import org.springframework.boot.actuate.health.Health;
import org.springframework.cloud.config.client.ConfigServicePropertySourceLocator;
import org.springframework.core.env.CompositePropertySource;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertySource;

public class ConfigServerHealthIndicator
extends AbstractHealthIndicator {
    private ConfigServicePropertySourceLocator locator;
    private Environment environment;

    public ConfigServerHealthIndicator(ConfigServicePropertySourceLocator locator, Environment environment) {
        this.environment = environment;
        this.locator = locator;
    }

    protected void doHealthCheck(Health.Builder builder) throws Exception {
        PropertySource<?> propertySource = this.locator.locate(this.environment);
        builder.up();
        if (propertySource instanceof CompositePropertySource) {
            ArrayList<String> sources = new ArrayList<String>();
            for (PropertySource ps : ((CompositePropertySource)propertySource).getPropertySources()) {
                sources.add(ps.getName());
            }
            builder.withDetail("propertySources", sources);
        } else if (propertySource != null) {
            builder.withDetail("propertySources", (Object)propertySource.toString());
        } else {
            builder.unknown().withDetail("error", (Object)"no property sources located");
        }
    }
}

