/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.monitor;

import java.beans.ConstructorProperties;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.cloud.bus.event.RefreshRemoteApplicationEvent;
import org.springframework.cloud.config.monitor.PropertyPathNotification;
import org.springframework.cloud.config.monitor.PropertyPathNotificationExtractor;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.http.HttpHeaders;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(path={"${spring.cloud.config.monitor.endpoint.path:}/monitor"})
public class PropertyPathEndpoint
implements ApplicationEventPublisherAware,
ApplicationContextAware {
    private static final Log log = LogFactory.getLog(PropertyPathEndpoint.class);
    private final PropertyPathNotificationExtractor extractor;
    private ApplicationEventPublisher applicationEventPublisher;
    private String contextId = UUID.randomUUID().toString();

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.contextId = applicationContext.getId();
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.applicationEventPublisher = applicationEventPublisher;
    }

    @RequestMapping(method={RequestMethod.POST})
    public Set<String> notifyByPath(@RequestHeader HttpHeaders headers, @RequestBody Map<String, Object> request) {
        PropertyPathNotification notification = this.extractor.extract((MultiValueMap<String, String>)headers, request);
        if (notification != null) {
            LinkedHashSet<String> services = new LinkedHashSet<String>();
            for (String path : notification.getPaths()) {
                services.addAll(this.guessServiceName(path));
            }
            if (this.applicationEventPublisher != null) {
                for (String service : services) {
                    log.info((Object)("Refresh for: " + service));
                    this.applicationEventPublisher.publishEvent((ApplicationEvent)new RefreshRemoteApplicationEvent((Object)this, this.contextId, service));
                }
                return services;
            }
        }
        return Collections.emptySet();
    }

    @RequestMapping(method={RequestMethod.POST}, consumes={"application/x-www-form-urlencoded"})
    public Set<String> notifyByForm(@RequestHeader HttpHeaders headers, @RequestParam(value="path") List<String> request) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        String key = "path";
        map.put(key, request);
        return this.notifyByPath(headers, map);
    }

    private Set<String> guessServiceName(String path) {
        LinkedHashSet<String> services = new LinkedHashSet<String>();
        if (path != null) {
            String name;
            String stem = StringUtils.stripFilenameExtension((String)StringUtils.getFilename((String)StringUtils.cleanPath((String)path)));
            int index = stem.indexOf("-");
            while (index >= 0) {
                name = stem.substring(0, index);
                String profile = stem.substring(index + 1);
                if ("application".equals(name)) {
                    services.add("*:" + profile);
                } else if (!name.startsWith("application")) {
                    services.add(name + ":" + profile);
                }
                index = stem.indexOf("-", index + 1);
            }
            name = stem;
            if ("application".equals(name)) {
                services.add("*");
            } else if (!name.startsWith("application")) {
                services.add(name);
            }
        }
        return services;
    }

    @ConstructorProperties(value={"extractor"})
    public PropertyPathEndpoint(PropertyPathNotificationExtractor extractor) {
        this.extractor = extractor;
    }
}

