/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.monitor;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.cloud.config.monitor.PropertyPathNotification;
import org.springframework.cloud.config.monitor.PropertyPathNotificationExtractor;
import org.springframework.util.MultiValueMap;

public abstract class BasePropertyPathNotificationExtractor
implements PropertyPathNotificationExtractor {
    @Override
    public PropertyPathNotification extract(MultiValueMap<String, String> headers, Map<String, Object> request) {
        if (this.requestBelongsToGitRepoManager(headers) && request.get("commits") instanceof Collection) {
            LinkedHashSet<String> paths = new LinkedHashSet<String>();
            Collection commits = (Collection)request.get("commits");
            this.addPaths(paths, commits);
            if (!paths.isEmpty()) {
                return new PropertyPathNotification(paths.toArray(new String[0]));
            }
        }
        return null;
    }

    protected void addPaths(Set<String> paths, Collection<Map<String, Object>> commits) {
        for (Map<String, Object> commit : commits) {
            this.addAllPaths(paths, commit, "added");
            this.addAllPaths(paths, commit, "removed");
            this.addAllPaths(paths, commit, "modified");
        }
    }

    private void addAllPaths(Set<String> paths, Map<String, Object> commit, String name) {
        Collection files = (Collection)commit.get(name);
        if (files != null) {
            paths.addAll(files);
        }
    }

    protected abstract boolean requestBelongsToGitRepoManager(MultiValueMap<String, String> var1);
}

