/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server;

import java.io.File;
import java.io.IOException;
import org.eclipse.jgit.util.FileUtils;
import org.springframework.util.FileSystemUtils;
import org.springframework.util.StringUtils;

public class ConfigServerTestUtils {
    public static String prepareLocalRepo() throws IOException {
        return ConfigServerTestUtils.prepareLocalRepo("./", "target/repos", "config-repo", "target/config");
    }

    public static String prepareLocalRepo(String repoPath) throws IOException {
        return ConfigServerTestUtils.prepareLocalRepo("./", "target/repos", repoPath, "target/config");
    }

    public static String prepareLocalRepo(String baseDir, String buildDir, String repoPath, String checkoutDir) throws IOException {
        buildDir = String.valueOf(baseDir) + buildDir;
        new File(buildDir).mkdirs();
        if (!repoPath.startsWith("/")) {
            repoPath = "/" + repoPath;
        }
        if (!repoPath.endsWith("/")) {
            repoPath = String.valueOf(repoPath) + "/";
        }
        File source = new File(String.valueOf(baseDir) + "src/test/resources" + repoPath);
        FileSystemUtils.copyRecursively((File)source, (File)new File(String.valueOf(buildDir) + repoPath));
        File dotGit = new File(String.valueOf(buildDir) + repoPath + ".git");
        File git = new File(String.valueOf(buildDir) + repoPath + "git");
        if (git.exists() && dotGit.exists()) {
            FileUtils.delete((File)dotGit, (int)1);
        }
        git.renameTo(dotGit);
        File local = new File(checkoutDir);
        if (local.exists()) {
            FileUtils.delete((File)local, (int)1);
        }
        if (!buildDir.startsWith("/")) {
            buildDir = "./" + buildDir;
        }
        return "file:" + buildDir + repoPath;
    }

    public static String prepareLocalSvnRepo(String sourceDir, String checkoutDir) throws Exception {
        File sourceDirFile = new File(sourceDir);
        sourceDirFile.mkdirs();
        File local = new File(checkoutDir);
        if (local.exists()) {
            FileUtils.delete((File)local, (int)1);
        }
        local.mkdirs();
        FileSystemUtils.copyRecursively((File)sourceDirFile, (File)local);
        return StringUtils.cleanPath((String)("file:///" + local.getAbsolutePath()));
    }

    public static String getBaseDirectory(String potentialRoot) {
        return new File(potentialRoot).exists() ? String.valueOf(potentialRoot) + "/" : "./";
    }

    public static String copyLocalRepo(String path) throws IOException {
        File dest = new File("target/repos/" + path);
        FileSystemUtils.deleteRecursively((File)dest);
        FileSystemUtils.copyRecursively((File)new File("target/repos/config-repo"), (File)dest);
        return "file:./target/repos/" + path;
    }

    public static boolean deleteLocalRepo(String path) throws IOException {
        File dest = new File("target/repos/" + path);
        return FileSystemUtils.deleteRecursively((File)dest);
    }
}

