/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.security.KeyPair;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.config.encrypt.EncryptorFactory;
import org.springframework.cloud.config.encrypt.KeyFormatException;
import org.springframework.cloud.config.environment.Environment;
import org.springframework.cloud.config.environment.PropertySource;
import org.springframework.cloud.config.server.InvalidCipherException;
import org.springframework.cloud.config.server.KeyNotAvailableException;
import org.springframework.cloud.config.server.KeyNotInstalledException;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.security.crypto.codec.Base64;
import org.springframework.security.crypto.codec.Hex;
import org.springframework.security.crypto.encrypt.TextEncryptor;
import org.springframework.security.rsa.crypto.KeyStoreKeyFactory;
import org.springframework.security.rsa.crypto.RsaKeyHolder;
import org.springframework.security.rsa.crypto.RsaSecretEncryptor;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"${spring.cloud.config.server.prefix:}"})
public class EncryptionController {
    private static Log logger = LogFactory.getLog(EncryptionController.class);
    private TextEncryptor encryptor;

    @Autowired(required=false)
    public void setEncryptor(TextEncryptor encryptor) {
        this.encryptor = encryptor;
    }

    @RequestMapping(value={"/key"}, method={RequestMethod.GET})
    public String getPublicKey() {
        if (!(this.encryptor instanceof RsaKeyHolder)) {
            throw new KeyNotAvailableException();
        }
        return ((RsaKeyHolder)this.encryptor).getPublicKey();
    }

    @RequestMapping(value={"/key"}, method={RequestMethod.POST}, params={"password"})
    public ResponseEntity<Map<String, Object>> uploadKeyStore(@RequestParam(value="file") MultipartFile file, @RequestParam(value="password") String password, @RequestParam(value="alias") String alias) {
        HashMap<String, String> body = new HashMap<String, String>();
        body.put("status", "OK");
        try {
            ByteArrayResource resource = new ByteArrayResource(file.getBytes());
            KeyPair keyPair = new KeyStoreKeyFactory((Resource)resource, password.toCharArray()).getKeyPair(alias);
            this.encryptor = new RsaSecretEncryptor(keyPair);
            body.put("publicKey", ((RsaKeyHolder)this.encryptor).getPublicKey());
        }
        catch (IOException e) {
            throw new KeyFormatException();
        }
        return new ResponseEntity(body, HttpStatus.CREATED);
    }

    @RequestMapping(value={"/key"}, method={RequestMethod.POST}, params={"!password"})
    public ResponseEntity<Map<String, Object>> uploadKey(@RequestBody String data, @RequestHeader(value="Content-Type") MediaType type) {
        HashMap<String, String> body = new HashMap<String, String>();
        body.put("status", "OK");
        this.encryptor = new EncryptorFactory().create(this.stripFormData(data, type, false));
        if (this.encryptor instanceof RsaKeyHolder) {
            body.put("publicKey", ((RsaKeyHolder)this.encryptor).getPublicKey());
        }
        return new ResponseEntity(body, HttpStatus.CREATED);
    }

    @ExceptionHandler(value={KeyFormatException.class})
    @ResponseBody
    public ResponseEntity<Map<String, Object>> keyFormat() {
        HashMap<String, String> body = new HashMap<String, String>();
        body.put("status", "BAD_REQUEST");
        body.put("description", "Key data not in correct format (PEM or jks keystore)");
        return new ResponseEntity(body, HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={KeyNotAvailableException.class})
    @ResponseBody
    public ResponseEntity<Map<String, Object>> keyUnavailable() {
        HashMap<String, String> body = new HashMap<String, String>();
        body.put("status", "NOT_FOUND");
        body.put("description", "No public key available");
        return new ResponseEntity(body, HttpStatus.NOT_FOUND);
    }

    @RequestMapping(value={"encrypt/status"}, method={RequestMethod.GET})
    public Map<String, Object> status() {
        if (this.encryptor == null) {
            throw new KeyNotInstalledException();
        }
        return Collections.singletonMap("status", "OK");
    }

    @RequestMapping(value={"encrypt"}, method={RequestMethod.POST})
    public String encrypt(@RequestBody String data, @RequestHeader(value="Content-Type") MediaType type) {
        if (this.encryptor == null) {
            throw new KeyNotInstalledException();
        }
        data = this.stripFormData(data, type, false);
        return this.encryptor.encrypt(data);
    }

    @RequestMapping(value={"decrypt"}, method={RequestMethod.POST})
    public String decrypt(@RequestBody String data, @RequestHeader(value="Content-Type") MediaType type) {
        if (this.encryptor == null) {
            throw new KeyNotInstalledException();
        }
        try {
            data = this.stripFormData(data, type, true);
            return this.encryptor.decrypt(data);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidCipherException();
        }
    }

    private String stripFormData(String data, MediaType type, boolean cipher) {
        if (data.endsWith("=") && !type.equals((Object)MediaType.TEXT_PLAIN)) {
            try {
                data = URLDecoder.decode(data, "UTF-8");
                if (cipher) {
                    data = data.replace(" ", "+");
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            String candidate = data.substring(0, data.length() - 1);
            if (cipher) {
                block8: {
                    if (data.endsWith("=") && data.length() / 2 != (data.length() + 1) / 2) {
                        try {
                            Hex.decode((CharSequence)candidate);
                            return candidate;
                        }
                        catch (IllegalArgumentException e) {
                            if (!Base64.isBase64((byte[])data.getBytes())) break block8;
                            return data;
                        }
                    }
                }
                return data;
            }
            data = candidate;
        }
        return data;
    }

    @ExceptionHandler(value={KeyNotInstalledException.class})
    @ResponseBody
    public ResponseEntity<Map<String, Object>> notInstalled() {
        HashMap<String, String> body = new HashMap<String, String>();
        body.put("status", "NO_KEY");
        body.put("description", "No key was installed for encryption service");
        return new ResponseEntity(body, HttpStatus.NOT_FOUND);
    }

    @ExceptionHandler(value={InvalidCipherException.class})
    @ResponseBody
    public ResponseEntity<Map<String, Object>> invalidCipher() {
        HashMap<String, String> body = new HashMap<String, String>();
        body.put("status", "INVALID");
        body.put("description", "Text not encrypted with this key");
        return new ResponseEntity(body, HttpStatus.BAD_REQUEST);
    }

    public Environment decrypt(Environment environment) {
        Environment result = new Environment(environment.getName(), environment.getLabel());
        for (PropertySource source : environment.getPropertySources()) {
            LinkedHashMap<String, String> map = new LinkedHashMap<String, String>(source.getSource());
            for (Map.Entry entry : new LinkedHashSet(map.entrySet())) {
                Object key = entry.getKey();
                String name = key.toString();
                String value = entry.getValue().toString();
                if (!value.startsWith("{cipher}")) continue;
                map.remove(key);
                if (this.encryptor == null) {
                    map.put(name, value);
                    continue;
                }
                try {
                    value = value == null ? null : this.encryptor.decrypt(value.substring("{cipher}".length()));
                }
                catch (Exception e) {
                    value = "<n/a>";
                    name = "invalid." + name;
                    logger.warn((Object)("Cannot decrypt key: " + key + " (" + e.getClass() + ": " + e.getMessage() + ")"));
                }
                map.put(name, value);
            }
            result.add(new PropertySource(source.getName(), map));
        }
        return result;
    }
}

