/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server;

import com.jcraft.jsch.Session;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jgit.api.CheckoutCommand;
import org.eclipse.jgit.api.CloneCommand;
import org.eclipse.jgit.api.CreateBranchCommand;
import org.eclipse.jgit.api.FetchCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.ListBranchCommand;
import org.eclipse.jgit.api.PullCommand;
import org.eclipse.jgit.api.TransportCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.JschConfigSessionFactory;
import org.eclipse.jgit.transport.OpenSshConfig;
import org.eclipse.jgit.transport.SshSessionFactory;
import org.eclipse.jgit.transport.UsernamePasswordCredentialsProvider;
import org.eclipse.jgit.util.FileUtils;
import org.springframework.cloud.config.environment.Environment;
import org.springframework.cloud.config.server.AbstractSCMEnvironmentRepository;
import org.springframework.cloud.config.server.SpringApplicationEnvironmentRepository;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.io.UrlResource;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class JGitEnvironmentRepository
extends AbstractSCMEnvironmentRepository {
    private static Log logger = LogFactory.getLog(JGitEnvironmentRepository.class);
    private boolean initialized;

    public JGitEnvironmentRepository(ConfigurableEnvironment environment) {
        super(environment);
    }

    protected ConfigurableEnvironment getEnvironment() {
        return this.environment;
    }

    protected void setEnvironment(ConfigurableEnvironment environment) {
        this.environment = environment;
    }

    @Override
    public Environment findOne(String application, String profile, String label) {
        this.initialize();
        Git git = null;
        try {
            git = this.createGitClient();
            Environment environment = this.loadEnvironment(git, application, profile, label);
            return environment;
        }
        catch (GitAPIException e) {
            throw new IllegalStateException("Cannot clone repository", e);
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot load environment", e);
        }
        finally {
            try {
                if (git != null) {
                    git.getRepository().close();
                }
            }
            catch (Exception e) {
                logger.warn((Object)"Could not close git repository", (Throwable)e);
            }
        }
    }

    public void afterPropertiesSet() throws Exception {
        Assert.state((this.uri != null ? 1 : 0) != 0, (String)"You need to configure a uri for the git repository");
    }

    private synchronized Environment loadEnvironment(Git git, String application, String profile, String label) throws GitAPIException {
        SpringApplicationEnvironmentRepository environment = new SpringApplicationEnvironmentRepository();
        git.getRepository().getConfig().setString("branch", label, "merge", label);
        Ref ref = this.checkout(git, label);
        if (this.shouldPull(git, ref)) {
            this.pull(git, label, ref);
        }
        environment.setSearchLocations(this.getSearchLocations(this.getWorkingDirectory()));
        return this.clean(environment.findOne(application, profile, ""));
    }

    private Ref checkout(Git git, String label) throws GitAPIException {
        CheckoutCommand checkout = git.checkout();
        if (this.shouldTrack(git, label)) {
            this.trackBranch(git, checkout, label);
        } else {
            checkout.setName(label);
        }
        return checkout.call();
    }

    private boolean shouldPull(Git git, Ref ref) throws GitAPIException {
        return git.status().call().isClean() && ref != null && git.getRepository().getConfig().getString("remote", "origin", "url") != null;
    }

    private boolean shouldTrack(Git git, String label) throws GitAPIException {
        return this.isBranch(git, label) && !this.isLocalBranch(git, label);
    }

    private void pull(Git git, String label, Ref ref) {
        PullCommand pull = git.pull();
        try {
            if (StringUtils.hasText((String)this.username)) {
                this.setCredentialsProvider((TransportCommand<?, ?>)pull);
            }
            pull.call();
        }
        catch (Exception e) {
            logger.warn((Object)("Could not pull remote for " + label + " (current ref=" + ref + "), remote: " + git.getRepository().getConfig().getString("remote", "origin", "url")));
        }
    }

    private Git createGitClient() throws IOException, GitAPIException {
        if (new File(this.basedir, ".git").exists()) {
            return this.openGitRepository();
        }
        return this.copyRepository();
    }

    private Git copyRepository() throws IOException, GitAPIException {
        this.deleteBaseDirIfExists();
        Assert.state((boolean)this.basedir.mkdirs(), (String)("Could not create basedir: " + this.basedir));
        if (this.uri.startsWith("file:")) {
            return this.copyFromLocalRepository();
        }
        return this.cloneToBasedir();
    }

    private Git openGitRepository() throws IOException {
        Git git = Git.open((File)this.getWorkingDirectory());
        this.tryFetch(git);
        return git;
    }

    private Git copyFromLocalRepository() throws IOException {
        File remote = new UrlResource(StringUtils.cleanPath((String)this.uri)).getFile();
        Assert.state((boolean)remote.isDirectory(), (String)("No directory at " + this.uri));
        File gitDir = new File(remote, ".git");
        Assert.state((boolean)gitDir.exists(), (String)("No .git at " + this.uri));
        Assert.state((boolean)gitDir.isDirectory(), (String)("No .git directory at " + this.uri));
        Git git = Git.open((File)remote);
        return git;
    }

    private Git cloneToBasedir() throws GitAPIException {
        CloneCommand clone = Git.cloneRepository().setURI(this.uri).setDirectory(this.basedir);
        if (StringUtils.hasText((String)this.username)) {
            this.setCredentialsProvider((TransportCommand<?, ?>)clone);
        }
        return clone.call();
    }

    private void tryFetch(Git git) {
        try {
            FetchCommand fetch = git.fetch();
            if (StringUtils.hasText((String)this.username)) {
                this.setCredentialsProvider((TransportCommand<?, ?>)fetch);
            }
            fetch.call();
        }
        catch (Exception e) {
            logger.warn((Object)"Remote repository not available");
        }
    }

    private void deleteBaseDirIfExists() {
        if (this.basedir.exists()) {
            try {
                FileUtils.delete((File)this.basedir, (int)1);
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to initialize base directory", e);
            }
        }
    }

    private void initialize() {
        if (this.uri.startsWith("file:") && !this.initialized) {
            SshSessionFactory.setInstance((SshSessionFactory)new JschConfigSessionFactory(){

                protected void configure(OpenSshConfig.Host hc, Session session) {
                    session.setConfig("StrictHostKeyChecking", "no");
                }
            });
            this.initialized = true;
        }
    }

    private void setCredentialsProvider(TransportCommand<?, ?> cmd) {
        cmd.setCredentialsProvider((CredentialsProvider)new UsernamePasswordCredentialsProvider(this.username, this.password));
    }

    private void trackBranch(Git git, CheckoutCommand checkout, String label) {
        checkout.setCreateBranch(true).setName(label).setUpstreamMode(CreateBranchCommand.SetupUpstreamMode.TRACK).setStartPoint("origin/" + label);
    }

    private boolean isBranch(Git git, String label) throws GitAPIException {
        return this.containsBranch(git, label, ListBranchCommand.ListMode.ALL);
    }

    private boolean isLocalBranch(Git git, String label) throws GitAPIException {
        return this.containsBranch(git, label, null);
    }

    private boolean containsBranch(Git git, String label, ListBranchCommand.ListMode listMode) throws GitAPIException {
        ListBranchCommand command = git.branchList();
        if (listMode != null) {
            command.setListMode(listMode);
        }
        List branches = command.call();
        for (Ref ref : branches) {
            if (!ref.getName().endsWith("/" + label)) continue;
            return true;
        }
        return false;
    }
}

