/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.cloud.config.environment.Environment;
import org.springframework.cloud.config.server.EnvironmentRepository;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;

public class NativeEnvironmentRepository
implements EnvironmentRepository {
    private Set<String> standardSources = new HashSet<String>(Arrays.asList("vcap", "systemProperties", "systemEnvironment", "jndiProperties", "servletConfigInitParams", "servletContextInitParams"));
    private ConfigurableEnvironment environment;

    public NativeEnvironmentRepository(ConfigurableEnvironment environment) {
        this.environment = environment;
    }

    @Override
    public Environment findOne(String application, String env, String label) {
        Environment result = new Environment(env, label);
        for (PropertySource source : this.environment.getPropertySources()) {
            String name = source.getName();
            if (this.standardSources.contains(name) || !(source instanceof MapPropertySource)) continue;
            result.add(new org.springframework.cloud.config.environment.PropertySource(name, (Map)source.getSource()));
        }
        return result;
    }
}

