/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server;

import java.io.File;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.cloud.config.environment.Environment;
import org.springframework.cloud.config.server.AbstractSCMEnvironmentRepository;
import org.springframework.cloud.config.server.SpringApplicationEnvironmentRepository;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.internal.wc.DefaultSVNAuthenticationManager;
import org.tmatesoft.svn.core.wc2.SvnCheckout;
import org.tmatesoft.svn.core.wc2.SvnOperationFactory;
import org.tmatesoft.svn.core.wc2.SvnTarget;
import org.tmatesoft.svn.core.wc2.SvnUpdate;

@ConfigurationProperties(value="spring.cloud.config.server.svn")
public class SVNKitEnvironmentRepository
extends AbstractSCMEnvironmentRepository {
    private static Log logger = LogFactory.getLog(SVNKitEnvironmentRepository.class);

    @Override
    public Environment findOne(String application, String profile, String label) {
        SvnOperationFactory svnOperationFactory = new SvnOperationFactory();
        if (StringUtils.hasText((String)this.getUsername())) {
            svnOperationFactory.setAuthenticationManager((ISVNAuthenticationManager)new DefaultSVNAuthenticationManager(null, false, this.getUsername(), this.getPassword()));
        }
        try {
            if (new File(this.getWorkingDirectory(), ".svn").exists()) {
                this.update(svnOperationFactory);
            } else {
                this.checkout(svnOperationFactory);
            }
            Environment environment = this.clean(this.loadEnvironment(application, profile, label));
            return environment;
        }
        catch (SVNException e) {
            throw new IllegalStateException("Cannot checkout repository", e);
        }
        finally {
            svnOperationFactory.dispose();
        }
    }

    private Environment loadEnvironment(String application, String profile, String label) {
        SpringApplicationEnvironmentRepository environmentRepository = new SpringApplicationEnvironmentRepository();
        environmentRepository.setSearchLocations(this.getSearchLocations(this.getSvnPath(this.getWorkingDirectory(), label)));
        return environmentRepository.findOne(application, profile, label);
    }

    private void checkout(SvnOperationFactory svnOperationFactory) throws SVNException {
        logger.debug((Object)("Checking out " + this.getUri() + " to: " + this.getWorkingDirectory().getAbsolutePath()));
        SvnCheckout checkout = svnOperationFactory.createCheckout();
        checkout.setSource(SvnTarget.fromURL((SVNURL)SVNURL.parseURIEncoded((String)this.getUri())));
        checkout.setSingleTarget(SvnTarget.fromFile((File)this.getWorkingDirectory()));
        checkout.run();
    }

    private void update(SvnOperationFactory svnOperationFactory) throws SVNException {
        logger.debug((Object)"Repo already checked out - updating instead.");
        SvnUpdate update = svnOperationFactory.createUpdate();
        update.setSingleTarget(SvnTarget.fromFile((File)this.getWorkingDirectory()));
        update.run();
    }

    public void afterPropertiesSet() throws Exception {
        Assert.state((this.getUri() != null ? 1 : 0) != 0, (String)"You need to configure a uri for the subversion repository (e.g. 'http://example.com/svn/')");
        this.resolveRelativeFileUri();
    }

    private void resolveRelativeFileUri() {
        if (this.getUri().startsWith("file:///./")) {
            String path = this.getUri().substring(8);
            String absolutePath = new File(path).getAbsolutePath();
            this.setUri("file:///" + StringUtils.cleanPath((String)absolutePath));
        }
    }

    public SVNKitEnvironmentRepository(ConfigurableEnvironment environment) {
        super(environment);
    }

    @Override
    protected File getWorkingDirectory() {
        return this.basedir;
    }

    private File getSvnPath(File workingDirectory, String label) {
        return new File(workingDirectory, label);
    }
}

