/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jgit.util.FileUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.cloud.config.environment.Environment;
import org.springframework.cloud.config.environment.PropertySource;
import org.springframework.cloud.config.server.EnvironmentRepository;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.io.UrlResource;
import org.springframework.util.PatternMatchUtils;
import org.springframework.util.StringUtils;

public abstract class AbstractScmEnvironmentRepository
implements EnvironmentRepository,
InitializingBean {
    private static Log logger = LogFactory.getLog(AbstractScmEnvironmentRepository.class);
    private File basedir;
    private String uri;
    private ConfigurableEnvironment environment;
    private String username;
    private String password;
    private String[] searchPaths = new String[0];

    public AbstractScmEnvironmentRepository(ConfigurableEnvironment environment) {
        this.environment = environment;
        this.basedir = this.createBaseDir();
    }

    private File createBaseDir() {
        try {
            final File basedir = Files.createTempDirectory("config-repo-", new FileAttribute[0]).toFile();
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    try {
                        FileUtils.delete((File)basedir, (int)1);
                    }
                    catch (IOException e) {
                        logger.warn((Object)("Failed to delete temporary directory on exit: " + e));
                    }
                }
            });
            return basedir;
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot create temp dir", e);
        }
    }

    protected ConfigurableEnvironment getEnvironment() {
        return this.environment;
    }

    protected void setEnvironment(ConfigurableEnvironment environment) {
        this.environment = environment;
    }

    public void setUri(String uri) {
        while (uri.endsWith("/")) {
            uri = uri.substring(0, uri.length() - 1);
        }
        this.uri = uri;
    }

    public String getUri() {
        return this.uri;
    }

    public void setBasedir(File basedir) {
        this.basedir = basedir.getAbsoluteFile();
    }

    public File getBasedir() {
        return this.basedir;
    }

    public void setSearchPaths(String ... searchPaths) {
        this.searchPaths = searchPaths;
    }

    public String[] getSearchPaths() {
        return this.searchPaths;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    protected File getWorkingDirectory() {
        if (this.uri.startsWith("file:")) {
            try {
                return new UrlResource(StringUtils.cleanPath((String)this.uri)).getFile();
            }
            catch (Exception e) {
                throw new IllegalStateException("Cannot convert uri to file: " + this.uri);
            }
        }
        return this.basedir;
    }

    protected String[] getSearchLocations(File dir) {
        ArrayList<String> locations = new ArrayList<String>();
        locations.add(dir.toURI().toString());
        String[] list = dir.list();
        if (list != null) {
            for (String path : list) {
                File file = new File(dir, path);
                if (!file.isDirectory() || !PatternMatchUtils.simpleMatch((String[])this.searchPaths, (String)path)) continue;
                locations.add(file.toURI().toString());
            }
        }
        return locations.toArray(new String[0]);
    }

    protected Environment clean(Environment value) {
        Environment result = new Environment(value.getName(), value.getProfiles(), value.getLabel());
        for (PropertySource source : value.getPropertySources()) {
            String name = source.getName().replace(this.getWorkingDirectory().toURI().toString(), "");
            name = name.replace("applicationConfig: [", "");
            name = this.uri + "/" + name.replace("]", "");
            result.add(new PropertySource(name, source.getSource()));
        }
        return result;
    }
}

