/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.config.client.ConfigClientProperties;
import org.springframework.cloud.config.server.ConfigServerConfiguration;
import org.springframework.cloud.config.server.ConfigServerProperties;
import org.springframework.cloud.config.server.EnvironmentRepository;
import org.springframework.cloud.config.server.EnvironmentRepositoryPropertySourceLocator;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.util.StringUtils;

@Configuration
public class ConfigServerBootstrapConfiguration {

    @ConditionalOnProperty(value={"spring.cloud.config.server.bootstrap"})
    @Import(value={ConfigServerConfiguration.class})
    protected static class LocalPropertySourceLocatorConfiguration {
        @Autowired
        private EnvironmentRepository repository;
        @Autowired
        private ConfigClientProperties client;
        @Autowired
        private ConfigServerProperties server;

        protected LocalPropertySourceLocatorConfiguration() {
        }

        @Bean
        public EnvironmentRepositoryPropertySourceLocator environmentRepositoryPropertySourceLocator() {
            return new EnvironmentRepositoryPropertySourceLocator(this.repository, this.client.getName(), this.client.getProfile(), this.getDefaultLabel());
        }

        private String getDefaultLabel() {
            if (StringUtils.hasText((String)this.client.getLabel())) {
                return this.client.getLabel();
            }
            if (StringUtils.hasText((String)this.server.getDefaultLabel())) {
                return this.server.getDefaultLabel();
            }
            return this.repository.getDefaultLabel();
        }
    }
}

