/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.http.HttpServletResponse;
import org.springframework.boot.bind.PropertiesConfigurationFactory;
import org.springframework.cloud.config.environment.Environment;
import org.springframework.cloud.config.server.EncryptionController;
import org.springframework.cloud.config.server.EnvironmentRepository;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.core.env.PropertySources;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.validation.BindException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.yaml.snakeyaml.Yaml;

@RestController
@RequestMapping(value={"${spring.cloud.config.server.prefix:}"})
public class EnvironmentController {
    private static final String MAP_PREFIX = "map";
    private EnvironmentRepository repository;
    private EncryptionController encryption;
    private String defaultLabel;
    private Map<String, String> overrides = new LinkedHashMap<String, String>();

    public EnvironmentController(EnvironmentRepository repository, EncryptionController encryption) {
        this.repository = repository;
        this.defaultLabel = repository.getDefaultLabel();
        this.encryption = encryption;
    }

    @RequestMapping(value={"/{name}/{profiles:.*[^-].*}"})
    public Environment defaultLabel(@PathVariable String name, @PathVariable String profiles) {
        return this.labelled(name, profiles, this.defaultLabel);
    }

    @RequestMapping(value={"/{name}/{profiles}/{label:.*}"})
    public Environment labelled(@PathVariable String name, @PathVariable String profiles, @PathVariable String label) {
        Environment environment = this.encryption.decrypt(this.repository.findOne(name, profiles, label));
        if (!this.overrides.isEmpty()) {
            environment.addFirst(new org.springframework.cloud.config.environment.PropertySource("overrides", this.overrides));
        }
        return environment;
    }

    @RequestMapping(value={"/{name}-{profiles}.properties"})
    public ResponseEntity<String> properties(@PathVariable String name, @PathVariable String profiles) throws IOException {
        return this.labelledProperties(name, profiles, this.defaultLabel);
    }

    @RequestMapping(value={"/{label}/{name}-{profiles}.properties"})
    public ResponseEntity<String> labelledProperties(@PathVariable String name, @PathVariable String profiles, @PathVariable String label) throws IOException {
        this.validateNameAndProfiles(name, profiles);
        Map<String, Object> properties = this.convertToProperties(this.labelled(name, profiles, label));
        return this.getSuccess(this.getPropertiesString(properties));
    }

    @RequestMapping(value={"{name}-{profiles}.json"})
    public ResponseEntity<Map<String, Object>> jsonProperties(@PathVariable String name, @PathVariable String profiles) throws Exception {
        return this.labelledJsonProperties(name, profiles, this.defaultLabel);
    }

    @RequestMapping(value={"/{label}/{name}-{profiles}.json"})
    public ResponseEntity<Map<String, Object>> labelledJsonProperties(@PathVariable String name, @PathVariable String profiles, @PathVariable String label) throws Exception {
        this.validateNameAndProfiles(name, profiles);
        Map<String, Object> properties = this.convertToMap(this.labelled(name, profiles, label));
        return this.getSuccess(properties, MediaType.APPLICATION_JSON);
    }

    private String getPropertiesString(Map<String, Object> properties) {
        StringBuilder output = new StringBuilder();
        for (Map.Entry<String, Object> entry : properties.entrySet()) {
            if (output.length() > 0) {
                output.append("\n");
            }
            String line = entry.getKey() + ": " + entry.getValue();
            output.append(line);
        }
        return output.toString();
    }

    @RequestMapping(value={"/{name}-{profiles}.yml", "/{name}-{profiles}.yaml"})
    public ResponseEntity<String> yaml(@PathVariable String name, @PathVariable String profiles) throws Exception {
        return this.labelledYaml(name, profiles, this.defaultLabel);
    }

    @RequestMapping(value={"/{label}/{name}-{profiles}.yml", "/{label}/{name}-{profiles}.yaml"})
    public ResponseEntity<String> labelledYaml(@PathVariable String name, @PathVariable String profiles, @PathVariable String label) throws Exception {
        this.validateNameAndProfiles(name, profiles);
        Map<String, Object> result = this.convertToMap(this.labelled(name, profiles, label));
        return this.getSuccess(new Yaml().dumpAsMap(result));
    }

    private Map<String, Object> convertToMap(Environment input) throws BindException {
        LinkedHashMap<String, Object> target = new LinkedHashMap<String, Object>();
        PropertiesConfigurationFactory factory = new PropertiesConfigurationFactory(target);
        Map<String, Object> data = this.convertToProperties(input);
        LinkedHashMap<String, Object> properties = new LinkedHashMap<String, Object>();
        for (String key : data.keySet()) {
            properties.put("map." + key, data.get(key));
        }
        this.addArrays(target, properties);
        MutablePropertySources propertySources = new MutablePropertySources();
        propertySources.addFirst((PropertySource)new MapPropertySource("properties", properties));
        factory.setPropertySources((PropertySources)propertySources);
        factory.bindPropertiesToTarget();
        Map result = (Map)target.get(MAP_PREFIX);
        return result == null ? new LinkedHashMap() : result;
    }

    @ExceptionHandler(value={IllegalArgumentException.class})
    public void illegalArgument(HttpServletResponse response) throws IOException {
        response.sendError(HttpStatus.BAD_REQUEST.value());
    }

    private void validateNameAndProfiles(String name, String profiles) {
        if (name.contains("-") || profiles.contains("-")) {
            throw new IllegalArgumentException("Properties output not supported for name or profiles containing hyphens");
        }
    }

    private HttpHeaders getHttpHeaders(MediaType mediaType) {
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.setContentType(mediaType);
        return httpHeaders;
    }

    private ResponseEntity<String> getSuccess(String body) {
        return new ResponseEntity((Object)body, (MultiValueMap)this.getHttpHeaders(MediaType.TEXT_PLAIN), HttpStatus.OK);
    }

    private ResponseEntity<Map<String, Object>> getSuccess(Map<String, Object> body, MediaType mediaType) {
        return new ResponseEntity(body, (MultiValueMap)this.getHttpHeaders(mediaType), HttpStatus.OK);
    }

    private void addArrays(Map<String, Object> target, Map<String, Object> properties) {
        for (String key : properties.keySet()) {
            int index = key.indexOf("[");
            Map<String, Object> current = target;
            if (index <= 0) continue;
            String stem = key.substring(0, index);
            String[] keys = StringUtils.delimitedListToStringArray((String)stem, (String)".");
            for (int i = 0; i < keys.length - 1; ++i) {
                Map map;
                if (current.get(keys[i]) == null) {
                    map = new LinkedHashMap();
                    current.put(keys[i], map);
                    current = map;
                    continue;
                }
                map = (Map)current.get(keys[i]);
                current = map;
            }
            String name = keys[keys.length - 1];
            if (current.get(name) == null) {
                current.put(name, new ArrayList());
            }
            List value = (List)current.get(name);
            int position = Integer.valueOf(key.substring(index + 1, key.indexOf("]")));
            while (position >= value.size()) {
                if (key.indexOf("].", index) > 0) {
                    value.add(new LinkedHashMap());
                    continue;
                }
                value.add("");
            }
        }
    }

    private Map<String, Object> convertToProperties(Environment profiles) {
        TreeMap<String, Object> map = new TreeMap<String, Object>();
        ArrayList sources = new ArrayList(profiles.getPropertySources());
        Collections.reverse(sources);
        for (org.springframework.cloud.config.environment.PropertySource source : sources) {
            Map value = source.getSource();
            map.putAll(value);
        }
        this.postProcessProperties(map);
        return map;
    }

    private void postProcessProperties(Map<String, Object> propertiesMap) {
        for (String key : propertiesMap.keySet()) {
            if (!key.equals("spring.profiles")) continue;
            propertiesMap.remove(key);
        }
    }

    public void setDefaultLabel(String defaultLabel) {
        this.defaultLabel = defaultLabel;
    }

    public void setOverrides(Map<String, String> overrides) {
        this.overrides = new HashMap<String, String>(overrides);
        for (String key : overrides.keySet()) {
            if (!overrides.get(key).contains("$\\{")) continue;
            this.overrides.put(key, overrides.get(key).replace("$\\{", "${"));
        }
    }
}

