/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.autoconfigure.PropertyPlaceholderAutoConfiguration;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.boot.context.config.ConfigFileApplicationListener;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.cloud.config.environment.Environment;
import org.springframework.cloud.config.server.EnvironmentRepository;
import org.springframework.cloud.config.server.PassthruEnvironmentRepository;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.core.env.StandardEnvironment;
import org.springframework.util.StringUtils;

@ConfigurationProperties(value="spring.cloud.config.server.native")
public class NativeEnvironmentRepository
implements EnvironmentRepository {
    private static Log logger = LogFactory.getLog(NativeEnvironmentRepository.class);
    private static final String DEFAULT_LABEL = "master";
    private String[] searchLocations;
    private boolean failOnError = false;
    private static final String[] DEFAULT_LOCATIONS = new String[]{"classpath:/", "classpath:/config/", "file:./", "file:./config/"};
    private ConfigurableEnvironment environment;

    public NativeEnvironmentRepository(ConfigurableEnvironment environment) {
        this.environment = environment;
    }

    public void setFailOnError(boolean failOnError) {
        this.failOnError = failOnError;
    }

    public boolean isFailOnError() {
        return this.failOnError;
    }

    @Override
    public String getDefaultLabel() {
        return DEFAULT_LABEL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Environment findOne(String config, String profile, String label) {
        SpringApplicationBuilder builder = new SpringApplicationBuilder(new Object[]{PropertyPlaceholderAutoConfiguration.class});
        ConfigurableEnvironment environment = this.getEnvironment(profile);
        builder.environment(environment);
        builder.web(false).showBanner(false);
        String[] args = this.getArgs(config, label);
        builder.application().setListeners(Collections.singletonList(new ConfigFileApplicationListener()));
        ConfigurableApplicationContext context = builder.run(args);
        environment.getPropertySources().remove("profiles");
        try {
            Environment environment2 = this.clean(new PassthruEnvironmentRepository(environment).findOne(config, profile, label));
            return environment2;
        }
        finally {
            context.close();
        }
    }

    private ConfigurableEnvironment getEnvironment(String profile) {
        StandardEnvironment environment = new StandardEnvironment();
        environment.getPropertySources().addFirst((PropertySource)new MapPropertySource("profiles", Collections.singletonMap("spring.profiles.active", profile)));
        return environment;
    }

    protected Environment clean(Environment value) {
        Environment result = new Environment(value.getName(), value.getProfiles(), value.getLabel());
        for (org.springframework.cloud.config.environment.PropertySource source : value.getPropertySources()) {
            String name = source.getName();
            if (this.environment.getPropertySources().contains(name)) continue;
            name = name.replace("applicationConfig: [", "");
            name = name.replace("]", "");
            if (this.searchLocations != null) {
                boolean matches = false;
                String normal = name;
                if (normal.startsWith("file:")) {
                    normal = new File(normal.substring("file:".length())).getAbsolutePath();
                }
                for (String pattern : StringUtils.commaDelimitedListToStringArray((String)this.getLocations(this.searchLocations, result.getLabel()))) {
                    if (!pattern.contains(":")) {
                        pattern = "file:" + pattern;
                    }
                    if (pattern.startsWith("file:")) {
                        pattern = StringUtils.cleanPath((String)new File(pattern.substring("file:".length())).getAbsolutePath()) + "/";
                    }
                    if (logger.isTraceEnabled()) {
                        logger.trace((Object)("Testing pattern: " + pattern + " with property source: " + name));
                    }
                    if (!normal.startsWith(pattern) || normal.substring(pattern.length()).contains("/")) continue;
                    matches = true;
                    break;
                }
                if (!matches) {
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug((Object)("Not adding property source: " + name));
                    continue;
                }
            }
            logger.info((Object)("Adding property source: " + name));
            result.add(new org.springframework.cloud.config.environment.PropertySource(name, source.getSource()));
        }
        return result;
    }

    private String[] getArgs(String config, String label) {
        ArrayList<String> list = new ArrayList<String>();
        if (!config.startsWith("application")) {
            config = "application," + config;
        }
        list.add("--spring.config.name=" + config);
        list.add("--spring.cloud.bootstrap.enabled=false");
        list.add("--encrypt.failOnError=" + this.failOnError);
        String[] locations = this.searchLocations;
        if (this.searchLocations == null) {
            locations = DEFAULT_LOCATIONS;
        }
        list.add("--spring.config.location=" + this.getLocations(locations, label));
        return list.toArray(new String[0]);
    }

    private String getLocations(String[] locations, String label) {
        ArrayList<String> output = new ArrayList<String>();
        for (String location : locations) {
            output.add(location);
        }
        for (String location : locations) {
            if (!this.isDirectory(location) || !StringUtils.hasText((String)label)) continue;
            output.add(location + label.trim() + "/");
        }
        return StringUtils.collectionToCommaDelimitedString(output);
    }

    public String[] getSearchLocations() {
        return this.searchLocations;
    }

    public void setSearchLocations(String ... locations) {
        this.searchLocations = locations;
        for (int i = 0; i < locations.length; ++i) {
            String location = locations[i];
            if (this.isDirectory(location) && !location.endsWith("/")) {
                location = location + "/";
            }
            locations[i] = location;
        }
    }

    private boolean isDirectory(String location) {
        return !location.endsWith(".properties") && !location.endsWith(".yml") && !location.endsWith(".yaml");
    }
}

