/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.ssh;

import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jgit.transport.URIish;
import org.springframework.cloud.config.server.environment.JGitEnvironmentProperties;
import org.springframework.cloud.config.server.environment.MultipleJGitEnvironmentProperties;
import org.springframework.cloud.config.server.ssh.SshPropertyValidator;

public class SshUriPropertyProcessor {
    private final MultipleJGitEnvironmentProperties sshUriProperties;

    public SshUriPropertyProcessor(MultipleJGitEnvironmentProperties sshUriProperties) {
        this.sshUriProperties = sshUriProperties;
    }

    public Map<String, JGitEnvironmentProperties> getSshKeysByHostname() {
        return this.extractNestedProperties(this.sshUriProperties);
    }

    private Map<String, JGitEnvironmentProperties> extractNestedProperties(MultipleJGitEnvironmentProperties uriProperties) {
        Map<String, MultipleJGitEnvironmentProperties.PatternMatchingJGitEnvironmentProperties> repos;
        HashMap<String, JGitEnvironmentProperties> sshUriPropertyMap = new HashMap<String, JGitEnvironmentProperties>();
        String parentUri = uriProperties.getUri();
        if (SshPropertyValidator.isSshUri(parentUri) && SshUriPropertyProcessor.getHostname(parentUri) != null) {
            sshUriPropertyMap.put(SshUriPropertyProcessor.getHostname(parentUri), uriProperties);
        }
        if ((repos = uriProperties.getRepos()) != null) {
            for (MultipleJGitEnvironmentProperties.PatternMatchingJGitEnvironmentProperties repoProperties : repos.values()) {
                String repoUri = repoProperties.getUri();
                if (!SshPropertyValidator.isSshUri(repoUri) || SshUriPropertyProcessor.getHostname(repoUri) == null) continue;
                sshUriPropertyMap.put(SshUriPropertyProcessor.getHostname(repoUri), repoProperties);
            }
        }
        return sshUriPropertyMap;
    }

    protected static String getHostname(String uri) {
        try {
            URIish urIish = new URIish(uri);
            return urIish.getHost();
        }
        catch (URISyntaxException e) {
            return null;
        }
    }
}

